package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The client making the token request
 */
@ApiModel(description = "The client making the token request")
@JsonPropertyOrder({ TokenPayLoadDataContextAllOfProtocolClient.JSON_PROPERTY_ID,
        TokenPayLoadDataContextAllOfProtocolClient.JSON_PROPERTY_NAME,
        TokenPayLoadDataContextAllOfProtocolClient.JSON_PROPERTY_TYPE })
@JsonTypeName("TokenPayLoad_data_context_allOf_protocol_client")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenPayLoadDataContextAllOfProtocolClient implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public TokenPayLoadDataContextAllOfProtocolClient() {
    }

    public TokenPayLoadDataContextAllOfProtocolClient id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier of the client
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier of the client")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TokenPayLoadDataContextAllOfProtocolClient name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the client
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name of the client")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TokenPayLoadDataContextAllOfProtocolClient type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The type of client
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "PUBLIC", value = "The type of client")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataContextAllOfProtocolClient tokenPayLoadDataContextAllOfProtocolClient = (TokenPayLoadDataContextAllOfProtocolClient) o;
        return Objects.equals(this.id, tokenPayLoadDataContextAllOfProtocolClient.id)
                && Objects.equals(this.name, tokenPayLoadDataContextAllOfProtocolClient.name)
                && Objects.equals(this.type, tokenPayLoadDataContextAllOfProtocolClient.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataContextAllOfProtocolClient {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
