package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RefreshToken;
import com.okta.sdk.resource.model.TokenProtocolRequest;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Information about the original token request used to get the refresh token being used, when in a refresh token
 * request
 */
@ApiModel(description = "Information about the original token request used to get the refresh token being used, when in a refresh token request")
@JsonPropertyOrder({ TokenPayLoadDataContextAllOfProtocolOriginalGrant.JSON_PROPERTY_REQUEST,
        TokenPayLoadDataContextAllOfProtocolOriginalGrant.JSON_PROPERTY_REFRESH_TOKEN })
@JsonTypeName("TokenPayLoad_data_context_allOf_protocol_OriginalGrant")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenPayLoadDataContextAllOfProtocolOriginalGrant implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REQUEST = "request";
    private TokenProtocolRequest request;

    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private RefreshToken refreshToken;

    public TokenPayLoadDataContextAllOfProtocolOriginalGrant() {
    }

    public TokenPayLoadDataContextAllOfProtocolOriginalGrant request(TokenProtocolRequest request) {

        this.request = request;
        return this;
    }

    /**
     * Get request
     *
     * @return request
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenProtocolRequest getRequest() {
        return request;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequest(TokenProtocolRequest request) {
        this.request = request;
    }

    public TokenPayLoadDataContextAllOfProtocolOriginalGrant refreshToken(RefreshToken refreshToken) {

        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Get refreshToken
     *
     * @return refreshToken
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RefreshToken getRefreshToken() {
        return refreshToken;
    }

    @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataContextAllOfProtocolOriginalGrant tokenPayLoadDataContextAllOfProtocolOriginalGrant = (TokenPayLoadDataContextAllOfProtocolOriginalGrant) o;
        return Objects.equals(this.request, tokenPayLoadDataContextAllOfProtocolOriginalGrant.request)
                && Objects.equals(this.refreshToken, tokenPayLoadDataContextAllOfProtocolOriginalGrant.refreshToken);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(request, refreshToken);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataContextAllOfProtocolOriginalGrant {\n");
        sb.append("    request: ").append(toIndentedString(request)).append("\n");
        sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
