package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import com.okta.sdk.resource.model.TrendMicroApexOneServiceApplicationSettings;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Schema for Trend Micro Apex One as a Service app (key name: &#x60;trendmicroapexoneservice&#x60;) To create a Trend
 * Micro Apex One as a Service app, use the [Create an
 * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication)
 * request with the following parameters in the request body. &gt; **Note:** The Trend Micro Apex One as a Service app
 * only supports &#x60;SAML_2_0&#x60; sign-on mode.
 */
@ApiModel(description = "Schema for Trend Micro Apex One as a Service app (key name: `trendmicroapexoneservice`)  To create a Trend Micro Apex One as a Service app, use the [Create an Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication) request with the following parameters in the request body. > **Note:** The Trend Micro Apex One as a Service app only supports `SAML_2_0` sign-on mode. ")
@JsonPropertyOrder({ TrendMicroApexOneServiceApplication.JSON_PROPERTY_ACCESSIBILITY,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_CREDENTIALS,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_LABEL,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_LICENSING,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_NAME,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_PROFILE,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_SIGN_ON_MODE,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_STATUS,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_VISIBILITY,
        TrendMicroApexOneServiceApplication.JSON_PROPERTY_SETTINGS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TrendMicroApexOneServiceApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;

    /**
     * Gets or Sets name
     */
    public enum NameEnum {
        TRENDMICROAPEXONESERVICE("trendmicroapexoneservice"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    /**
     * Gets or Sets signOnMode
     */
    public enum SignOnModeEnum {
        SAML_2_0("SAML_2_0"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        SignOnModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SignOnModeEnum fromValue(String value) {
            for (SignOnModeEnum b : SignOnModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private SignOnModeEnum signOnMode;

    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;

    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private TrendMicroApexOneServiceApplicationSettings settings;

    public TrendMicroApexOneServiceApplication() {
    }

    public TrendMicroApexOneServiceApplication accessibility(ApplicationAccessibility accessibility) {

        this.accessibility = accessibility;
        return this;
    }

    /**
     * Get accessibility
     *
     * @return accessibility
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationAccessibility getAccessibility() {
        return accessibility;
    }

    @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    public TrendMicroApexOneServiceApplication credentials(SchemeApplicationCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SchemeApplicationCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public TrendMicroApexOneServiceApplication label(String label) {

        this.label = label;
        return this;
    }

    /**
     * User-defined display name for app
     *
     * @return label
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "User-defined display name for app")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public TrendMicroApexOneServiceApplication licensing(ApplicationLicensing licensing) {

        this.licensing = licensing;
        return this;
    }

    /**
     * Get licensing
     *
     * @return licensing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LICENSING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLicensing getLicensing() {
        return licensing;
    }

    @JsonProperty(JSON_PROPERTY_LICENSING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    public TrendMicroApexOneServiceApplication name(NameEnum name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "trendmicroapexoneservice", required = true, value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public NameEnum getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public TrendMicroApexOneServiceApplication profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public TrendMicroApexOneServiceApplication putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to
     * OAuth 2.0 client apps)
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps)")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public TrendMicroApexOneServiceApplication signOnMode(SignOnModeEnum signOnMode) {

        this.signOnMode = signOnMode;
        return this;
    }

    /**
     * Get signOnMode
     *
     * @return signOnMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SignOnModeEnum getSignOnMode() {
        return signOnMode;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
    }

    public TrendMicroApexOneServiceApplication status(ApplicationLifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public TrendMicroApexOneServiceApplication visibility(ApplicationVisibility visibility) {

        this.visibility = visibility;
        return this;
    }

    /**
     * Get visibility
     *
     * @return visibility
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VISIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationVisibility getVisibility() {
        return visibility;
    }

    @JsonProperty(JSON_PROPERTY_VISIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public TrendMicroApexOneServiceApplication settings(TrendMicroApexOneServiceApplicationSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public TrendMicroApexOneServiceApplicationSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSettings(TrendMicroApexOneServiceApplicationSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrendMicroApexOneServiceApplication trendMicroApexOneServiceApplication = (TrendMicroApexOneServiceApplication) o;
        return Objects.equals(this.accessibility, trendMicroApexOneServiceApplication.accessibility)
                && Objects.equals(this.credentials, trendMicroApexOneServiceApplication.credentials)
                && Objects.equals(this.label, trendMicroApexOneServiceApplication.label)
                && Objects.equals(this.licensing, trendMicroApexOneServiceApplication.licensing)
                && Objects.equals(this.name, trendMicroApexOneServiceApplication.name)
                && Objects.equals(this.profile, trendMicroApexOneServiceApplication.profile)
                && Objects.equals(this.signOnMode, trendMicroApexOneServiceApplication.signOnMode)
                && Objects.equals(this.status, trendMicroApexOneServiceApplication.status)
                && Objects.equals(this.visibility, trendMicroApexOneServiceApplication.visibility)
                && Objects.equals(this.settings, trendMicroApexOneServiceApplication.settings);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessibility, credentials, label, licensing, name, profile, signOnMode, status, visibility,
                settings);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrendMicroApexOneServiceApplication {\n");
        sb.append("    accessibility: ").append(toIndentedString(accessibility)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    licensing: ").append(toIndentedString(licensing)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    signOnMode: ").append(toIndentedString(signOnMode)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
