package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Describes how the account is blocked from access. If &#x60;appliesTo&#x60; is &#x60;ANY_DEVICES&#x60;, then the
 * account is blocked for all devices. If &#x60;appliesTo&#x60; is &#x60;UNKNOWN_DEVICES&#x60;, then the account is only
 * blocked for unknown devices.
 */
@ApiModel(description = "Describes how the account is blocked from access. If `appliesTo` is `ANY_DEVICES`, then the account is blocked for all devices. If `appliesTo` is `UNKNOWN_DEVICES`, then the account is only blocked for unknown devices.")
@JsonPropertyOrder({ UserBlock.JSON_PROPERTY_APPLIES_TO, UserBlock.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserBlock implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The devices that the block applies to
     */
    public enum AppliesToEnum {
        ANY_DEVICES("ANY_DEVICES"),

        UNKNOWN_DEVICES("UNKNOWN_DEVICES"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        AppliesToEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static AppliesToEnum fromValue(String value) {
            for (AppliesToEnum b : AppliesToEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_APPLIES_TO = "appliesTo";
    private AppliesToEnum appliesTo;

    /**
     * Type of access block
     */
    public enum TypeEnum {
        DEVICE_BASED("DEVICE_BASED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public UserBlock() {
    }

    /*
     * @JsonCreator public UserBlock(
     *
     * @JsonProperty(JSON_PROPERTY_APPLIES_TO) AppliesToEnum appliesTo,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) TypeEnum type ) { this(); this.appliesTo = appliesTo; this.type = type; }
     */

    /**
     * The devices that the block applies to
     *
     * @return appliesTo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The devices that the block applies to")
    @JsonProperty(JSON_PROPERTY_APPLIES_TO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppliesToEnum getAppliesTo() {
        return appliesTo;
    }

    /**
     * Type of access block
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of access block")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserBlock userBlock = (UserBlock) o;
        return Objects.equals(this.appliesTo, userBlock.appliesTo) && Objects.equals(this.type, userBlock.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appliesTo, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserBlock {\n");
        sb.append("    appliesTo: ").append(toIndentedString(appliesTo)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
