package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorTokenAllOfVerify;
import com.okta.sdk.resource.model.UserFactorTokenProfile;
import com.okta.sdk.resource.model.UserFactorType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorToken
 */
@JsonPropertyOrder({ UserFactorToken.JSON_PROPERTY_PROFILE, UserFactorToken.JSON_PROPERTY_VERIFY })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "factorType", visible = true, defaultImpl = UserFactorToken.class)

public class UserFactorToken extends UserFactor implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserFactorTokenProfile profile;

    public static final String JSON_PROPERTY_VERIFY = "verify";
    private UserFactorTokenAllOfVerify verify;

    public UserFactorToken() {
    }

    /*
     * @JsonCreator public UserFactorToken(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_VENDOR_NAME) String vendorName,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created; this.id =
     * id; this.lastUpdated = lastUpdated; this.vendorName = vendorName; this.embedded = embedded; }
     */

    public UserFactorToken profile(UserFactorTokenProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorTokenProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(UserFactorTokenProfile profile) {
        this.profile = profile;
    }

    public UserFactorToken verify(UserFactorTokenAllOfVerify verify) {

        this.verify = verify;
        return this;
    }

    /**
     * Get verify
     *
     * @return verify
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VERIFY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorTokenAllOfVerify getVerify() {
        return verify;
    }

    @JsonProperty(JSON_PROPERTY_VERIFY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVerify(UserFactorTokenAllOfVerify verify) {
        this.verify = verify;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorToken userFactorToken = (UserFactorToken) o;
        return Objects.equals(this.profile, userFactorToken.profile)
                && Objects.equals(this.verify, userFactorToken.verify);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile, verify, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorToken {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    verify: ").append(toIndentedString(verify)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
