package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserRiskGetResponseLinks;
import com.okta.sdk.resource.model.UserRiskLevelPut;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserRiskPutResponse
 */
@JsonPropertyOrder({ UserRiskPutResponse.JSON_PROPERTY_REASON, UserRiskPutResponse.JSON_PROPERTY_RISK_LEVEL,
        UserRiskPutResponse.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserRiskPutResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public static final String JSON_PROPERTY_RISK_LEVEL = "riskLevel";
    private UserRiskLevelPut riskLevel;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserRiskGetResponseLinks links;

    public UserRiskPutResponse() {
    }

    public UserRiskPutResponse reason(String reason) {

        this.reason = reason;
        return this;
    }

    /**
     * Describes the risk level for the user
     *
     * @return reason
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Admin override risk", value = "Describes the risk level for the user")
    @JsonProperty(JSON_PROPERTY_REASON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReason() {
        return reason;
    }

    @JsonProperty(JSON_PROPERTY_REASON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public UserRiskPutResponse riskLevel(UserRiskLevelPut riskLevel) {

        this.riskLevel = riskLevel;
        return this;
    }

    /**
     * Get riskLevel
     *
     * @return riskLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserRiskLevelPut getRiskLevel() {
        return riskLevel;
    }

    @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRiskLevel(UserRiskLevelPut riskLevel) {
        this.riskLevel = riskLevel;
    }

    public UserRiskPutResponse links(UserRiskGetResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserRiskGetResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserRiskGetResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserRiskPutResponse userRiskPutResponse = (UserRiskPutResponse) o;
        return Objects.equals(this.reason, userRiskPutResponse.reason)
                && Objects.equals(this.riskLevel, userRiskPutResponse.riskLevel)
                && Objects.equals(this.links, userRiskPutResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(reason, riskLevel, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRiskPutResponse {\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    riskLevel: ").append(toIndentedString(riskLevel)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
