package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Credential response object for enrolled credential details, along with enrollment and key identifiers to associate
 * the credential
 */
@ApiModel(description = "Credential response object for enrolled credential details, along with enrollment and key identifiers to associate the credential")
@JsonPropertyOrder({ WebAuthnCredResponse.JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID,
        WebAuthnCredResponse.JSON_PROPERTY_CRED_RESPONSE_J_W_E })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WebAuthnCredResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID = "authenticatorEnrollmentId";
    private String authenticatorEnrollmentId;

    public static final String JSON_PROPERTY_CRED_RESPONSE_J_W_E = "credResponseJWE";
    private String credResponseJWE;

    public WebAuthnCredResponse() {
    }

    public WebAuthnCredResponse authenticatorEnrollmentId(String authenticatorEnrollmentId) {

        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
        return this;
    }

    /**
     * ID for a WebAuthn Preregistration Factor in Okta
     *
     * @return authenticatorEnrollmentId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for a WebAuthn Preregistration Factor in Okta")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorEnrollmentId() {
        return authenticatorEnrollmentId;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentId(String authenticatorEnrollmentId) {
        this.authenticatorEnrollmentId = authenticatorEnrollmentId;
    }

    public WebAuthnCredResponse credResponseJWE(String credResponseJWE) {

        this.credResponseJWE = credResponseJWE;
        return this;
    }

    /**
     * Encrypted JWE of credential response from the fulfillment provider
     *
     * @return credResponseJWE
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Encrypted JWE of credential response from the fulfillment provider")
    @JsonProperty(JSON_PROPERTY_CRED_RESPONSE_J_W_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCredResponseJWE() {
        return credResponseJWE;
    }

    @JsonProperty(JSON_PROPERTY_CRED_RESPONSE_J_W_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredResponseJWE(String credResponseJWE) {
        this.credResponseJWE = credResponseJWE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WebAuthnCredResponse webAuthnCredResponse = (WebAuthnCredResponse) o;
        return Objects.equals(this.authenticatorEnrollmentId, webAuthnCredResponse.authenticatorEnrollmentId)
                && Objects.equals(this.credResponseJWE, webAuthnCredResponse.credResponseJWE);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticatorEnrollmentId, credResponseJWE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebAuthnCredResponse {\n");
        sb.append("    authenticatorEnrollmentId: ").append(toIndentedString(authenticatorEnrollmentId)).append("\n");
        sb.append("    credResponseJWE: ").append(toIndentedString(credResponseJWE)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
