package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Metadata about Okta as a transmitter and relevant information for configuration.
 */
@ApiModel(description = "Metadata about Okta as a transmitter and relevant information for configuration.")
@JsonPropertyOrder({ WellKnownSSFMetadata.JSON_PROPERTY_CONFIGURATION_ENDPOINT,
        WellKnownSSFMetadata.JSON_PROPERTY_DELIVERY_METHODS_SUPPORTED, WellKnownSSFMetadata.JSON_PROPERTY_ISSUER,
        WellKnownSSFMetadata.JSON_PROPERTY_JWKS_URI })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WellKnownSSFMetadata implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONFIGURATION_ENDPOINT = "configuration_endpoint";
    private URI configurationEndpoint;

    public static final String JSON_PROPERTY_DELIVERY_METHODS_SUPPORTED = "delivery_methods_supported";
    private List<URI> deliveryMethodsSupported = null;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private URI jwksUri;

    public WellKnownSSFMetadata() {
    }

    public WellKnownSSFMetadata configurationEndpoint(URI configurationEndpoint) {

        this.configurationEndpoint = configurationEndpoint;
        return this;
    }

    /**
     * The URL of the SSF Stream configuration endpoint
     *
     * @return configurationEndpoint
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{yourOktaDomain}/api/v1/ssf/stream", value = "The URL of the SSF Stream configuration endpoint")
    @JsonProperty(JSON_PROPERTY_CONFIGURATION_ENDPOINT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getConfigurationEndpoint() {
        return configurationEndpoint;
    }

    @JsonProperty(JSON_PROPERTY_CONFIGURATION_ENDPOINT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurationEndpoint(URI configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public WellKnownSSFMetadata deliveryMethodsSupported(List<URI> deliveryMethodsSupported) {

        this.deliveryMethodsSupported = deliveryMethodsSupported;
        return this;
    }

    public WellKnownSSFMetadata adddeliveryMethodsSupportedItem(URI deliveryMethodsSupportedItem) {
        if (this.deliveryMethodsSupported == null) {
            this.deliveryMethodsSupported = new ArrayList<>();
        }
        this.deliveryMethodsSupported.add(deliveryMethodsSupportedItem);
        return this;
    }

    /**
     * An array of supported SET delivery methods
     *
     * @return deliveryMethodsSupported
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"https://schemas.openid.net/secevent/risc/delivery-method/push\",\"urn:ietf:rfc:8935\"]", value = "An array of supported SET delivery methods")
    @JsonProperty(JSON_PROPERTY_DELIVERY_METHODS_SUPPORTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<URI> getDeliveryMethodsSupported() {
        return deliveryMethodsSupported;
    }

    @JsonProperty(JSON_PROPERTY_DELIVERY_METHODS_SUPPORTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryMethodsSupported(List<URI> deliveryMethodsSupported) {
        this.deliveryMethodsSupported = deliveryMethodsSupported;
    }

    public WellKnownSSFMetadata issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * The issuer used in Security Event Tokens. This value is set as &#x60;iss&#x60; in the claim.
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{yourOktaDomain}", value = "The issuer used in Security Event Tokens. This value is set as `iss` in the claim.")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public WellKnownSSFMetadata jwksUri(URI jwksUri) {

        this.jwksUri = jwksUri;
        return this;
    }

    /**
     * The URL of the JSON Web Key Set (JWKS) that contains the signing keys for validating the signatures of Security
     * Event Tokens (SETs)
     *
     * @return jwksUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{yourOktaDomain}/oauth2/v1/keys", value = "The URL of the JSON Web Key Set (JWKS) that contains the signing keys for validating the signatures of Security Event Tokens (SETs)")
    @JsonProperty(JSON_PROPERTY_JWKS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getJwksUri() {
        return jwksUri;
    }

    @JsonProperty(JSON_PROPERTY_JWKS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WellKnownSSFMetadata wellKnownSSFMetadata = (WellKnownSSFMetadata) o;
        return Objects.equals(this.configurationEndpoint, wellKnownSSFMetadata.configurationEndpoint)
                && Objects.equals(this.deliveryMethodsSupported, wellKnownSSFMetadata.deliveryMethodsSupported)
                && Objects.equals(this.issuer, wellKnownSSFMetadata.issuer)
                && Objects.equals(this.jwksUri, wellKnownSSFMetadata.jwksUri);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(configurationEndpoint, deliveryMethodsSupported, issuer, jwksUri);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnownSSFMetadata {\n");
        sb.append("    configurationEndpoint: ").append(toIndentedString(configurationEndpoint)).append("\n");
        sb.append("    deliveryMethodsSupported: ").append(toIndentedString(deliveryMethodsSupported)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    jwksUri: ").append(toIndentedString(jwksUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
