# EventHookApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateEventHook**](EventHookApi.md#activateEventHook) | **POST** /api/v1/eventHooks/{eventHookId}/lifecycle/activate | Activate an Event Hook |
| [**createEventHook**](EventHookApi.md#createEventHook) | **POST** /api/v1/eventHooks | Create an Event Hook |
| [**deactivateEventHook**](EventHookApi.md#deactivateEventHook) | **POST** /api/v1/eventHooks/{eventHookId}/lifecycle/deactivate | Deactivate an Event Hook |
| [**deleteEventHook**](EventHookApi.md#deleteEventHook) | **DELETE** /api/v1/eventHooks/{eventHookId} | Delete an Event Hook |
| [**getEventHook**](EventHookApi.md#getEventHook) | **GET** /api/v1/eventHooks/{eventHookId} | Retrieve an Event Hook |
| [**listEventHooks**](EventHookApi.md#listEventHooks) | **GET** /api/v1/eventHooks | List all Event Hooks |
| [**replaceEventHook**](EventHookApi.md#replaceEventHook) | **PUT** /api/v1/eventHooks/{eventHookId} | Replace an Event Hook |
| [**verifyEventHook**](EventHookApi.md#verifyEventHook) | **POST** /api/v1/eventHooks/{eventHookId}/lifecycle/verify | Verify an Event Hook |



## activateEventHook

> EventHook activateEventHook(eventHookId)

Activate an Event Hook

Activates the event hook that matches the provided &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        String eventHookId = "who8vt36qfNpCGz9H1e6"; // String | `id` of the Event Hook
        try {
            EventHook result = apiInstance.activateEventHook(eventHookId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#activateEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHookId** | **String**| &#x60;id&#x60; of the Event Hook | |

### Return type

[**EventHook**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createEventHook

> EventHook createEventHook(eventHook)

Create an Event Hook

Creates a new event hook for your organization in &#x60;ACTIVE&#x60; status. You pass an event hook object in the JSON payload of your request. That object represents the set of required information about the event hook you&#39;re registering, including:   * The URI of your external service   * The [events](https://developer.okta.com/docs/reference/api/event-types/) in Okta you want to subscribe to   * An optional event hook filter that can reduce the number of event hook calls. This is a self-service Early Access (EA) feature.     See [Create an event hook filter](https://developer.okta.com/docs/concepts/event-hooks/#create-an-event-hook-filter).      Additionally, you can specify a secret API key for Okta to pass to your external service endpoint for security verification. Note that the API key you set here is unrelated to the Okta API token you must supply when making calls to Okta APIs. Optionally, you can specify extra headers that Okta passes to your external service with each call. Your external service must use a valid HTTPS endpoint.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        EventHook eventHook = new EventHook(); // EventHook | 
        try {
            EventHook result = apiInstance.createEventHook(eventHook);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#createEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHook** | [**EventHook**](EventHook.md)|  | |

### Return type

[**EventHook**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deactivateEventHook

> EventHook deactivateEventHook(eventHookId)

Deactivate an Event Hook

Deactivates the event hook that matches the provided &#x60;id&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        String eventHookId = "who8vt36qfNpCGz9H1e6"; // String | `id` of the Event Hook
        try {
            EventHook result = apiInstance.deactivateEventHook(eventHookId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#deactivateEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHookId** | **String**| &#x60;id&#x60; of the Event Hook | |

### Return type

[**EventHook**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteEventHook

> deleteEventHook(eventHookId)

Delete an Event Hook

Deletes the event hook that matches the provided &#x60;id&#x60;. After deletion, the event hook is unrecoverable. As a safety precaution, you can only delete event hooks with a status of &#x60;INACTIVE&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        String eventHookId = "who8vt36qfNpCGz9H1e6"; // String | `id` of the Event Hook
        try {
            apiInstance.deleteEventHook(eventHookId);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#deleteEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHookId** | **String**| &#x60;id&#x60; of the Event Hook | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getEventHook

> EventHook getEventHook(eventHookId)

Retrieve an Event Hook

Retrieves an event hook

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        String eventHookId = "who8vt36qfNpCGz9H1e6"; // String | `id` of the Event Hook
        try {
            EventHook result = apiInstance.getEventHook(eventHookId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#getEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHookId** | **String**| &#x60;id&#x60; of the Event Hook | |

### Return type

[**EventHook**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listEventHooks

> List&lt;EventHook&gt; listEventHooks()

List all Event Hooks

Lists all event hooks

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        try {
            List<EventHook> result = apiInstance.listEventHooks();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#listEventHooks");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**List&lt;EventHook&gt;**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceEventHook

> EventHook replaceEventHook(eventHookId, eventHook)

Replace an Event Hook

Replaces an event hook. Okta validates the new properties before replacing the existing values. Some event hook properties are immutable and can&#39;t be updated. Refer to the parameter description in the request body schema.  &gt;**Note:** Updating the &#x60;channel&#x60; property requires you to verify the hook again.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        String eventHookId = "who8vt36qfNpCGz9H1e6"; // String | `id` of the Event Hook
        EventHook eventHook = new EventHook(); // EventHook | 
        try {
            EventHook result = apiInstance.replaceEventHook(eventHookId, eventHook);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#replaceEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHookId** | **String**| &#x60;id&#x60; of the Event Hook | |
| **eventHook** | [**EventHook**](EventHook.md)|  | |

### Return type

[**EventHook**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## verifyEventHook

> EventHook verifyEventHook(eventHookId)

Verify an Event Hook

Verifies that the event hook matches the provided &#x60;eventHookId&#x60;. To verify ownership, your endpoint must send information back to Okta in JSON format. See [Event hooks](https://developer.okta.com/docs/concepts/event-hooks/#one-time-verification-request).  Only &#x60;ACTIVE&#x60; and &#x60;VERIFIED&#x60; event hooks can receive events from Okta.  If a response is not received within 3 seconds, the outbound request times out. One retry is attempted after a timeout or error response. If a successful response still isn&#39;t received, this operation returns a 400 error with more information about the failure.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.EventHookApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        EventHookApi apiInstance = new EventHookApi(defaultClient);
        String eventHookId = "who8vt36qfNpCGz9H1e6"; // String | `id` of the Event Hook
        try {
            EventHook result = apiInstance.verifyEventHook(eventHookId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EventHookApi#verifyEventHook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **eventHookId** | **String**| &#x60;id&#x60; of the Event Hook | |

### Return type

[**EventHook**](EventHook.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

