# IdentityProviderApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**activateIdentityProvider**](IdentityProviderApi.md#activateIdentityProvider) | **POST** /api/v1/idps/{idpId}/lifecycle/activate | Activate an Identity Provider |
| [**createIdentityProvider**](IdentityProviderApi.md#createIdentityProvider) | **POST** /api/v1/idps | Create an Identity Provider |
| [**deactivateIdentityProvider**](IdentityProviderApi.md#deactivateIdentityProvider) | **POST** /api/v1/idps/{idpId}/lifecycle/deactivate | Deactivate an Identity Provider |
| [**deleteIdentityProvider**](IdentityProviderApi.md#deleteIdentityProvider) | **DELETE** /api/v1/idps/{idpId} | Delete an Identity Provider |
| [**getIdentityProvider**](IdentityProviderApi.md#getIdentityProvider) | **GET** /api/v1/idps/{idpId} | Retrieve an Identity Provider |
| [**listIdentityProviders**](IdentityProviderApi.md#listIdentityProviders) | **GET** /api/v1/idps | List all Identity Providers |
| [**replaceIdentityProvider**](IdentityProviderApi.md#replaceIdentityProvider) | **PUT** /api/v1/idps/{idpId} | Replace an Identity Provider |



## activateIdentityProvider

> IdentityProvider activateIdentityProvider(idpId)

Activate an Identity Provider

Activates an inactive IdP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        try {
            IdentityProvider result = apiInstance.activateIdentityProvider(idpId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#activateIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## createIdentityProvider

> IdentityProvider createIdentityProvider(identityProvider)

Create an Identity Provider

Creates a new Identity Provider integration.  #### SAML 2.0 Identity Provider  You must first add the IdP&#39;s signature certificate to the IdP key store before you can add a SAML 2.0 IdP with a &#x60;kid&#x60; credential reference.   Don&#39;t use &#x60;fromURI&#x60; to automatically redirect a user to a particular app after successfully authenticating with a third-party IdP. Instead, use SAML deep links. Using &#x60;fromURI&#x60; isn&#39;t tested or supported. For more information about using deep links when signing users in using an SP-initiated flow, see [Understanding SP-Initiated Login flow](https://developer.okta.com/docs/concepts/saml/#understanding-sp-initiated-login-flow).  Use SAML deep links to automatically redirect the user to an app after successfully authenticating with a third-party IdP. To use deep links, assemble these three parts into a URL:  * SP ACS URL&lt;br&gt; For example: &#x60;https://${yourOktaDomain}/sso/saml2/:idpId&#x60; * The app to which the user is automatically redirected after successfully authenticating with the IdP &lt;br&gt; For example: &#x60;/app/:app-location/:appId/sso/saml&#x60; * Optionally, if the app is an outbound SAML app, you can specify the &#x60;relayState&#x60; passed to it.&lt;br&gt; For example: &#x60;?RelayState&#x3D;:anyUrlEncodedValue&#x60;  The deep link for the above three parts is:&lt;br&gt; &#x60;https://${yourOktaDomain}/sso/saml2/:idpId/app/:app-location/:appId/sso/saml?RelayState&#x3D;:anyUrlEncodedValue&#x60;  #### Smart Card X509 Identity Provider  You must first add the IdP&#39;s server certificate to the IdP key store before you can add a Smart Card &#x60;X509&#x60; IdP with a &#x60;kid&#x60; credential reference.  You need to upload the whole trust chain as a single key using the [Key Store API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProviderKeys/#tag/IdentityProviderKeys/operation/createIdentityProviderKey). Depending on the information stored in the smart card, select the proper [template](https://developer.okta.com/docs/reference/okta-expression-language/#idp-user-profile) &#x60;idpuser.subjectAltNameEmail&#x60; or &#x60;idpuser.subjectAltNameUpn&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        IdentityProvider identityProvider = new IdentityProvider(); // IdentityProvider | IdP settings
        try {
            IdentityProvider result = apiInstance.createIdentityProvider(identityProvider);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#createIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **identityProvider** | [**IdentityProvider**](IdentityProvider.md)| IdP settings | |

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## deactivateIdentityProvider

> IdentityProvider deactivateIdentityProvider(idpId)

Deactivate an Identity Provider

Deactivates an active IdP

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        try {
            IdentityProvider result = apiInstance.deactivateIdentityProvider(idpId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#deactivateIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteIdentityProvider

> deleteIdentityProvider(idpId)

Delete an Identity Provider

Deletes an identity provider integration by &#x60;idpId&#x60; * All existing IdP users are unlinked with the highest order profile source taking precedence for each IdP user. * Unlinked users keep their existing authentication provider such as &#x60;FEDERATION&#x60; or &#x60;SOCIAL&#x60;.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        try {
            apiInstance.deleteIdentityProvider(idpId);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#deleteIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## getIdentityProvider

> IdentityProvider getIdentityProvider(idpId)

Retrieve an Identity Provider

Retrieves an identity provider integration by &#x60;idpId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        try {
            IdentityProvider result = apiInstance.getIdentityProvider(idpId);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#getIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listIdentityProviders

> List&lt;IdentityProvider&gt; listIdentityProviders(q, after, limit, type)

List all Identity Providers

Lists all identity provider integrations with pagination. A subset of IdPs can be returned that match a supported filter expression or query.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        String q = "Example SAML"; // String | Searches the `name` property of IdPs for matching value
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | A limit on the number of objects to return
        IdentityProviderType type = IdentityProviderType.fromValue("AMAZON"); // IdentityProviderType | Filters IdPs by `type`
        try {
            List<IdentityProvider> result = apiInstance.listIdentityProviders(q, after, limit, type);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#listIdentityProviders");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **q** | **String**| Searches the &#x60;name&#x60; property of IdPs for matching value | [optional] |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| A limit on the number of objects to return | [optional] [default to 20] |
| **type** | [**IdentityProviderType**](.md)| Filters IdPs by &#x60;type&#x60; | [optional] [enum: AMAZON, APPLE, DISCORD, FACEBOOK, GITHUB, GITLAB, GOOGLE, LINKEDIN, LOGINGOV, LOGINGOV_SANDBOX, MICROSOFT, OIDC, PAYPAL, PAYPAL_SANDBOX, SALESFORCE, SAML2, SPOTIFY, X509, XERO, YAHOO, YAHOOJP] |

### Return type

[**List&lt;IdentityProvider&gt;**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **429** | Too Many Requests |  -  |


## replaceIdentityProvider

> IdentityProvider replaceIdentityProvider(idpId, identityProvider)

Replace an Identity Provider

Replaces an identity provider integration by &#x60;idpId&#x60;

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.IdentityProviderApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        IdentityProviderApi apiInstance = new IdentityProviderApi(defaultClient);
        String idpId = "0oa62bfdjnK55Z5x80h7"; // String | `id` of IdP
        IdentityProvider identityProvider = new IdentityProvider(); // IdentityProvider | Updated configuration for the IdP
        try {
            IdentityProvider result = apiInstance.replaceIdentityProvider(idpId, identityProvider);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling IdentityProviderApi#replaceIdentityProvider");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **idpId** | **String**| &#x60;id&#x60; of IdP | |
| **identityProvider** | [**IdentityProvider**](IdentityProvider.md)| Updated configuration for the IdP | |

### Return type

[**IdentityProvider**](IdentityProvider.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **400** | Bad Request |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

