# OrgSettingMetadataApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getWellknownOrgMetadata**](OrgSettingMetadataApi.md#getWellknownOrgMetadata) | **GET** /.well-known/okta-organization | Retrieve the Well-Known Org Metadata |



## getWellknownOrgMetadata

> WellKnownOrgMetadata getWellknownOrgMetadata()

Retrieve the Well-Known Org Metadata

Retrieves the well-known org metadata, which includes the org ID, configured custom domains, authentication pipeline, and various other org settings

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.OrgSettingMetadataApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");

        OrgSettingMetadataApi apiInstance = new OrgSettingMetadataApi(defaultClient);
        try {
            WellKnownOrgMetadata result = apiInstance.getWellknownOrgMetadata();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling OrgSettingMetadataApi#getWellknownOrgMetadata");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**WellKnownOrgMetadata**](WellKnownOrgMetadata.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **429** | Too Many Requests |  -  |

