# RoleBTargetBGroupApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignAppInstanceTargetToAppAdminRoleForGroup**](RoleBTargetBGroupApi.md#assignAppInstanceTargetToAppAdminRoleForGroup) | **PUT** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId} | Assign an Group Role Application Instance Target |
| [**assignAppTargetToAdminRoleForGroup**](RoleBTargetBGroupApi.md#assignAppTargetToAdminRoleForGroup) | **PUT** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName} | Assign an Group Role Application Target |
| [**assignGroupTargetToGroupAdminRole**](RoleBTargetBGroupApi.md#assignGroupTargetToGroupAdminRole) | **PUT** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/groups/{targetGroupId} | Assign a Group Role Group Target |
| [**listApplicationTargetsForApplicationAdministratorRoleForGroup**](RoleBTargetBGroupApi.md#listApplicationTargetsForApplicationAdministratorRoleForGroup) | **GET** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps | List all Group Role Application Targets |
| [**listGroupTargetsForGroupRole**](RoleBTargetBGroupApi.md#listGroupTargetsForGroupRole) | **GET** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/groups | List all Group Role Group Targets |
| [**unassignAppInstanceTargetToAppAdminRoleForGroup**](RoleBTargetBGroupApi.md#unassignAppInstanceTargetToAppAdminRoleForGroup) | **DELETE** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId} | Unassign an Group Role Application Instance Target |
| [**unassignAppTargetToAdminRoleForGroup**](RoleBTargetBGroupApi.md#unassignAppTargetToAdminRoleForGroup) | **DELETE** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName} | Unassign a Group Role Application Target |
| [**unassignGroupTargetFromGroupAdminRole**](RoleBTargetBGroupApi.md#unassignGroupTargetFromGroupAdminRole) | **DELETE** /api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/groups/{targetGroupId} | Unassign a Group Role Group Target |



## assignAppInstanceTargetToAppAdminRoleForGroup

> assignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleAssignmentId, appName, appId)

Assign an Group Role Application Instance Target

Assigns an app instance target to an &#x60;APP_ADMIN&#x60; Role Assignment to a Group. When you assign the first OIN app or app instance target, you reduce the scope of the Role Assignment. The Role no longer applies to all app targets, but applies only to the specified target. &gt; **Note:** You can target a mixture of both OIN app and app instance targets, but you can&#39;t assign permissions to manage all instances of an OIN app and then assign a subset of permissions to the same app. For example, you can&#39;t specify that an admin has access to manage all instances of the Salesforce app and then also manage specific configurations of the Salesforce app.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.assignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleAssignmentId, appName, appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#assignAppInstanceTargetToAppAdminRoleForGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignAppTargetToAdminRoleForGroup

> assignAppTargetToAdminRoleForGroup(groupId, roleAssignmentId, appName)

Assign an Group Role Application Target

Assigns an OIN app target to an &#x60;APP_ADMIN&#x60; Role Assignment to a Group. When you assign the first OIN app target, you reduce the scope of the Role Assignment. The Role no longer applies to all app targets but applies only to the specified target. An OIN app target that&#39;s assigned to the Role overrides any existing instance targets of the OIN app. For example, if a user is assigned to administer a specific Facebook instance, a successful request to add an OIN app with &#x60;facebook&#x60; for &#x60;appName&#x60; makes that user the administrator for all Facebook instances.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        try {
            apiInstance.assignAppTargetToAdminRoleForGroup(groupId, roleAssignmentId, appName);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#assignAppTargetToAdminRoleForGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## assignGroupTargetToGroupAdminRole

> assignGroupTargetToGroupAdminRole(groupId, roleAssignmentId, targetGroupId)

Assign a Group Role Group Target

Assigns a Group target to a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a Group.   When you assign the first Group target, you reduce the scope of the Role Assignment. The Role no longer applies to all targets but applies only to the specified target. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String targetGroupId = "00g1e9dfjHeLAsdX983d"; // String | 
        try {
            apiInstance.assignGroupTargetToGroupAdminRole(groupId, roleAssignmentId, targetGroupId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#assignGroupTargetToGroupAdminRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **targetGroupId** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listApplicationTargetsForApplicationAdministratorRoleForGroup

> List&lt;CatalogApplication&gt; listApplicationTargetsForApplicationAdministratorRoleForGroup(groupId, roleAssignmentId, after, limit)

List all Group Role Application Targets

Lists all app targets for an &#x60;APP_ADMIN&#x60; Role Assignment to a Group. The response includes a list of OIN-cataloged apps or app instances. The response payload for an app instance contains the &#x60;id&#x60; property, but an OIN-cataloged app doesn&#39;t.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String after = "after_example"; // String | 
        Integer limit = 20; // Integer | 
        try {
            List<CatalogApplication> result = apiInstance.listApplicationTargetsForApplicationAdministratorRoleForGroup(groupId, roleAssignmentId, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#listApplicationTargetsForApplicationAdministratorRoleForGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to 20] |

### Return type

[**List&lt;CatalogApplication&gt;**](CatalogApplication.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listGroupTargetsForGroupRole

> List&lt;Group&gt; listGroupTargetsForGroupRole(groupId, roleAssignmentId, after, limit)

List all Group Role Group Targets

Lists all Group targets for a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a Group.   If the Role isn&#39;t scoped to specific Group targets, an empty array &#x60;[]&#x60; is returned. 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String after = "after_example"; // String | 
        Integer limit = 20; // Integer | 
        try {
            List<Group> result = apiInstance.listGroupTargetsForGroupRole(groupId, roleAssignmentId, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#listGroupTargetsForGroupRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **after** | **String**|  | [optional] |
| **limit** | **Integer**|  | [optional] [default to 20] |

### Return type

[**List&lt;Group&gt;**](Group.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignAppInstanceTargetToAppAdminRoleForGroup

> unassignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleAssignmentId, appName, appId)

Unassign an Group Role Application Instance Target

Unassigns an app instance target from an &#x60;APP_ADMIN&#x60; Role Assignment to a Group &gt; **Note:** You can&#39;t remove the last app instance target from a Role Assignment since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete the &#x60;APP_ADMIN&#x60; Role Assignment and recreate a new one. See [Unassign a Group Role](/openapi/okta-management/management/tag/RoleAssignmentBGroup/#tag/RoleAssignmentBGroup/operation/unassignRoleFromGroup).

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        String appId = "0oafxqCAJWWGELFTYASJ"; // String | Application ID
        try {
            apiInstance.unassignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleAssignmentId, appName, appId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#unassignAppInstanceTargetToAppAdminRoleForGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |
| **appId** | **String**| Application ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignAppTargetToAdminRoleForGroup

> unassignAppTargetToAdminRoleForGroup(groupId, roleAssignmentId, appName)

Unassign a Group Role Application Target

Unassigns an OIN app target from an &#x60;APP_ADMIN&#x60; Role Assignment to a Group  &gt; **Note:** You can&#39;t remove the last app target from a Role Assignment, since this causes an exception. &gt; If you need a Role Assignment that applies to all apps, delete the &#x60;APP_ADMIN&#x60; Role Assignment and recreate a new one. See [Unassign a Group Role](/openapi/okta-management/management/tag/RoleAssignmentBGroup/#tag/RoleAssignmentBGroup/operation/unassignRoleFromGroup). 

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String appName = "oidc_client"; // String | Application name for the app type
        try {
            apiInstance.unassignAppTargetToAdminRoleForGroup(groupId, roleAssignmentId, appName);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#unassignAppTargetToAdminRoleForGroup");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **appName** | **String**| Application name for the app type | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## unassignGroupTargetFromGroupAdminRole

> unassignGroupTargetFromGroupAdminRole(groupId, roleAssignmentId, targetGroupId)

Unassign a Group Role Group Target

Unassigns a Group target from a &#x60;USER_ADMIN&#x60;, &#x60;HELP_DESK_ADMIN&#x60;, or &#x60;GROUP_MEMBERSHIP_ADMIN&#x60; Role Assignment to a Group.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.RoleBTargetBGroupApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        RoleBTargetBGroupApi apiInstance = new RoleBTargetBGroupApi(defaultClient);
        String groupId = "00g1emaKYZTWRYYRRTSK"; // String | The `id` of the group
        String roleAssignmentId = "JBCUYUC7IRCVGS27IFCE2SKO"; // String | The `id` of the Role Assignment
        String targetGroupId = "00g1e9dfjHeLAsdX983d"; // String | 
        try {
            apiInstance.unassignGroupTargetFromGroupAdminRole(groupId, roleAssignmentId, targetGroupId);
        } catch (ApiException e) {
            System.err.println("Exception when calling RoleBTargetBGroupApi#unassignGroupTargetFromGroupAdminRole");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **groupId** | **String**| The &#x60;id&#x60; of the group | |
| **roleAssignmentId** | **String**| The &#x60;id&#x60; of the Role Assignment | |
| **targetGroupId** | **String**|  | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

