# UserLinkedObjectApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**assignLinkedObjectValueForPrimary**](UserLinkedObjectApi.md#assignLinkedObjectValueForPrimary) | **PUT** /api/v1/users/{userIdOrLogin}/linkedObjects/{primaryRelationshipName}/{primaryUserId} | Assign a Linked Object value for primary |
| [**deleteLinkedObjectForUser**](UserLinkedObjectApi.md#deleteLinkedObjectForUser) | **DELETE** /api/v1/users/{userIdOrLogin}/linkedObjects/{relationshipName} | Delete a Linked Object value |
| [**listLinkedObjectsForUser**](UserLinkedObjectApi.md#listLinkedObjectsForUser) | **GET** /api/v1/users/{userIdOrLogin}/linkedObjects/{relationshipName} | List the primary or all of the associated Linked Object values |



## assignLinkedObjectValueForPrimary

> assignLinkedObjectValueForPrimary(userIdOrLogin, primaryRelationshipName, primaryUserId)

Assign a Linked Object value for primary

Assigns the first User as the &#x60;associated&#x60; and the second User as the &#x60;primary&#x60; for the specified relationship.  If the first User is already associated with a different &#x60;primary&#x60; for this relationship, the previous link is removed. A Linked Object relationship can specify only one primary User for an associated User.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserLinkedObjectApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserLinkedObjectApi apiInstance = new UserLinkedObjectApi(defaultClient);
        String userIdOrLogin = "00u5zex6ztMbOZhF50h7"; // String | If for the `self` link, the ID of the User for whom you want to get the primary User ID. If for the `associated` relation, the User ID or login value of the User assigned the associated relationship.  This can be `me` to represent the current session User.
        String primaryRelationshipName = "manager"; // String | Name of the `primary` relationship being assigned
        String primaryUserId = "primaryUserId_example"; // String | User ID to be assigned to the `primary` relationship for the `associated` user
        try {
            apiInstance.assignLinkedObjectValueForPrimary(userIdOrLogin, primaryRelationshipName, primaryUserId);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserLinkedObjectApi#assignLinkedObjectValueForPrimary");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userIdOrLogin** | **String**| If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the associated relationship.  This can be &#x60;me&#x60; to represent the current session User. | |
| **primaryRelationshipName** | **String**| Name of the &#x60;primary&#x60; relationship being assigned | |
| **primaryUserId** | **String**| User ID to be assigned to the &#x60;primary&#x60; relationship for the &#x60;associated&#x60; user | |

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## deleteLinkedObjectForUser

> deleteLinkedObjectForUser(userIdOrLogin, relationshipName)

Delete a Linked Object value

Deletes any existing relationship between the &#x60;associated&#x60; and &#x60;primary&#x60; user. For the &#x60;associated&#x60; User, this is specified by the ID. The &#x60;primary&#x60; name specifies the relationship.  The operation is successful if the relationship is deleted or if the specified User isn&#39;t in the &#x60;associated&#x60; relationship for any instance of the specified &#x60;primary&#x60; and thus, no relationship is found.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserLinkedObjectApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserLinkedObjectApi apiInstance = new UserLinkedObjectApi(defaultClient);
        String userIdOrLogin = "00u5zex6ztMbOZhF50h7"; // String | If for the `self` link, the ID of the User for whom you want to get the primary User ID. If for the `associated` relation, the User ID or login value of the User assigned the associated relationship.  This can be `me` to represent the current session User.
        String relationshipName = "manager"; // String | Name of the `primary` or `associated` relationship being queried
        try {
            apiInstance.deleteLinkedObjectForUser(userIdOrLogin, relationshipName);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserLinkedObjectApi#deleteLinkedObjectForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userIdOrLogin** | **String**| If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the associated relationship.  This can be &#x60;me&#x60; to represent the current session User. | |
| **relationshipName** | **String**| Name of the &#x60;primary&#x60; or &#x60;associated&#x60; relationship being queried | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listLinkedObjectsForUser

> List&lt;ResponseLinks&gt; listLinkedObjectsForUser(userIdOrLogin, relationshipName)

List the primary or all of the associated Linked Object values

Lists either the &#x60;self&#x60; link for the primary User or all associated Users in the relationship specified by &#x60;relationshipName&#x60;. If the specified User isn&#39;t associated in any relationship, an empty array is returned.  Use &#x60;me&#x60; instead of &#x60;id&#x60; to specify the current session User.

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserLinkedObjectApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserLinkedObjectApi apiInstance = new UserLinkedObjectApi(defaultClient);
        String userIdOrLogin = "00u5zex6ztMbOZhF50h7"; // String | If for the `self` link, the ID of the User for whom you want to get the primary User ID. If for the `associated` relation, the User ID or login value of the User assigned the associated relationship.  This can be `me` to represent the current session User.
        String relationshipName = "manager"; // String | Name of the `primary` or `associated` relationship being queried
        try {
            List<ResponseLinks> result = apiInstance.listLinkedObjectsForUser(userIdOrLogin, relationshipName);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserLinkedObjectApi#listLinkedObjectsForUser");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userIdOrLogin** | **String**| If for the &#x60;self&#x60; link, the ID of the User for whom you want to get the primary User ID. If for the &#x60;associated&#x60; relation, the User ID or login value of the User assigned the associated relationship.  This can be &#x60;me&#x60; to represent the current session User. | |
| **relationshipName** | **String**| Name of the &#x60;primary&#x60; or &#x60;associated&#x60; relationship being queried | |

### Return type

[**List&lt;ResponseLinks&gt;**](ResponseLinks.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

