/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Device;
import com.okta.sdk.resource.model.DeviceList;
import com.okta.sdk.resource.model.DeviceUser;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DeviceApi {

    private ApiClient apiClient;

    public DeviceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Device Activates a Device by setting its status to ACTIVE by &#x60;deviceId&#x60;. Activated devices
     * are used to create and delete Device user links.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateDevice(String deviceId) throws ApiException {
        this.activateDevice(deviceId, Collections.emptyMap());
    }

    /**
     * Activate a Device Activates a Device by setting its status to ACTIVE by &#x60;deviceId&#x60;. Activated devices
     * are used to create and delete Device user links.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateDevice(String deviceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling activateDevice");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}/lifecycle/activate".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Deactivate a Device Deactivates a Device by setting its status to DEACTIVATED by &#x60;deviceId&#x60;.
     * Deactivation causes a Device to lose all device user links. Set the Device status to DEACTIVATED before deleting
     * it. &gt; **Note:** When deactivating a Device, keep in mind the following: - Device deactivation is a destructive
     * operation for device factors and client certificates. Device reenrollment using Okta Verify allows end users to
     * set up new factors on the device. - Device deletion removes the device record from Okta. Reenrollment creates a
     * new device record.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateDevice(String deviceId) throws ApiException {
        this.deactivateDevice(deviceId, Collections.emptyMap());
    }

    /**
     * Deactivate a Device Deactivates a Device by setting its status to DEACTIVATED by &#x60;deviceId&#x60;.
     * Deactivation causes a Device to lose all device user links. Set the Device status to DEACTIVATED before deleting
     * it. &gt; **Note:** When deactivating a Device, keep in mind the following: - Device deactivation is a destructive
     * operation for device factors and client certificates. Device reenrollment using Okta Verify allows end users to
     * set up new factors on the device. - Device deletion removes the device record from Okta. Reenrollment creates a
     * new device record.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateDevice(String deviceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling deactivateDevice");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}/lifecycle/deactivate".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete a Device Deletes (permanently) a device by &#x60;deviceId&#x60; if it has a status of
     * &#x60;DEACTIVATED&#x60;. You can transition the device to &#x60;DEACTIVATED&#x60; status using the [Deactivate a
     * Device](/openapi/okta-management/management/tag/Device/#tag/Device/operation/deactivateDevice) endpoint. This
     * request is destructive and deletes all of the profile data related to the device. Once deleted, device data
     * can&#39;t be recovered. However, reenrollment creates a new device record. &gt; **Note:** Attempts to delete a
     * device that isn&#39;t in a &#x60;DEACTIVATED&#x60; state raise an error.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteDevice(String deviceId) throws ApiException {
        this.deleteDevice(deviceId, Collections.emptyMap());
    }

    /**
     * Delete a Device Deletes (permanently) a device by &#x60;deviceId&#x60; if it has a status of
     * &#x60;DEACTIVATED&#x60;. You can transition the device to &#x60;DEACTIVATED&#x60; status using the [Deactivate a
     * Device](/openapi/okta-management/management/tag/Device/#tag/Device/operation/deactivateDevice) endpoint. This
     * request is destructive and deletes all of the profile data related to the device. Once deleted, device data
     * can&#39;t be recovered. However, reenrollment creates a new device record. &gt; **Note:** Attempts to delete a
     * device that isn&#39;t in a &#x60;DEACTIVATED&#x60; state raise an error.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteDevice(String deviceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling deleteDevice");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Device Retrieves a device by &#x60;deviceId&#x60;
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @return Device
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Device getDevice(String deviceId) throws ApiException {
        return this.getDevice(deviceId, Collections.emptyMap());
    }

    /**
     * Retrieve a Device Retrieves a device by &#x60;deviceId&#x60;
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Device
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Device getDevice(String deviceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling getDevice");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Device> localVarReturnType = new TypeReference<Device>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Users for a Device Lists all Users for a Device by &#x60;deviceId&#x60;
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @return List&lt;DeviceUser&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DeviceUser> listDeviceUsers(String deviceId) throws ApiException {
        return this.listDeviceUsers(deviceId, Collections.emptyMap());
    }

    /**
     * List all Users for a Device Lists all Users for a Device by &#x60;deviceId&#x60;
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;DeviceUser&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DeviceUser> listDeviceUsers(String deviceId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling listDeviceUsers");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}/users".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<DeviceUser>> localVarReturnType = new TypeReference<List<DeviceUser>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Devices Lists all devices with pagination support. You can return a subset of Devices that match a
     * supported search criteria using the &#x60;search&#x60; query parameter. Searches for devices based on the
     * properties specified in the &#x60;search&#x60; parameter conforming SCIM filter specifications
     * (case-insensitive). This data is eventually consistent. The API returns different results depending on specified
     * queries in the request. Empty list is returned if no objects match &#x60;search&#x60; request. &gt; **Note:**
     * Listing devices with &#x60;search&#x60; should not be used as a part of any critical flows—such as authentication
     * or updates—to prevent potential data loss. &#x60;search&#x60; results may not reflect the latest information, as
     * this endpoint uses a search index which may not be up-to-date with recent updates to the object. &lt;br&gt;
     * Don&#39;t use search results directly for record updates, as the data might be stale and therefore overwrite
     * newer data, resulting in data loss. &lt;br&gt; Use an &#x60;id&#x60; lookup for records that you update to ensure
     * your results contain the latest data. This operation requires [URL
     * encoding](https://www.w3.org/TR/html4/interact/forms.html#h-17.13.4.1). For example,
     * &#x60;search&#x3D;profile.displayName eq \&quot;Bob\&quot;&#x60; is encoded as
     * &#x60;search&#x3D;profile.displayName%20eq%20%22Bob%22&#x60;.
     *
     * @param after
     *            (optional)
     * @param limit
     *            A limit on the number of objects to return (recommend &#x60;20&#x60;) (optional, default to 200)
     * @param search
     *            A SCIM filter expression that filters the results. Searches include all Device &#x60;profile&#x60;
     *            properties and the Device &#x60;id&#x60;, &#x60;status&#x60;, and &#x60;lastUpdated&#x60; properties.
     *            (optional)
     * @param expand
     *            Includes associated user details and management status for the device in the &#x60;_embedded&#x60;
     *            attribute (optional)
     *
     * @return List&lt;DeviceList&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DeviceList> listDevices(String after, Integer limit, String search, String expand) throws ApiException {
        return this.listDevices(after, limit, search, expand, Collections.emptyMap());
    }

    /**
     * List all Devices Lists all devices with pagination support. You can return a subset of Devices that match a
     * supported search criteria using the &#x60;search&#x60; query parameter. Searches for devices based on the
     * properties specified in the &#x60;search&#x60; parameter conforming SCIM filter specifications
     * (case-insensitive). This data is eventually consistent. The API returns different results depending on specified
     * queries in the request. Empty list is returned if no objects match &#x60;search&#x60; request. &gt; **Note:**
     * Listing devices with &#x60;search&#x60; should not be used as a part of any critical flows—such as authentication
     * or updates—to prevent potential data loss. &#x60;search&#x60; results may not reflect the latest information, as
     * this endpoint uses a search index which may not be up-to-date with recent updates to the object. &lt;br&gt;
     * Don&#39;t use search results directly for record updates, as the data might be stale and therefore overwrite
     * newer data, resulting in data loss. &lt;br&gt; Use an &#x60;id&#x60; lookup for records that you update to ensure
     * your results contain the latest data. This operation requires [URL
     * encoding](https://www.w3.org/TR/html4/interact/forms.html#h-17.13.4.1). For example,
     * &#x60;search&#x3D;profile.displayName eq \&quot;Bob\&quot;&#x60; is encoded as
     * &#x60;search&#x3D;profile.displayName%20eq%20%22Bob%22&#x60;.
     *
     * @param after
     *            (optional)
     * @param limit
     *            A limit on the number of objects to return (recommend &#x60;20&#x60;) (optional, default to 200)
     * @param search
     *            A SCIM filter expression that filters the results. Searches include all Device &#x60;profile&#x60;
     *            properties and the Device &#x60;id&#x60;, &#x60;status&#x60;, and &#x60;lastUpdated&#x60; properties.
     *            (optional)
     * @param expand
     *            Includes associated user details and management status for the device in the &#x60;_embedded&#x60;
     *            attribute (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;DeviceList&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<DeviceList> listDevices(String after, Integer limit, String search, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/devices";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<DeviceList>> localVarReturnType = new TypeReference<List<DeviceList>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Suspend a Device Suspends a Device by setting its status to SUSPENDED. Use suspended devices to create and delete
     * device user links. You can only unsuspend or deactivate suspended devices. &gt; **Note:** SUSPENDED status is
     * meant to be temporary, so it isn&#39;t destructive.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void suspendDevice(String deviceId) throws ApiException {
        this.suspendDevice(deviceId, Collections.emptyMap());
    }

    /**
     * Suspend a Device Suspends a Device by setting its status to SUSPENDED. Use suspended devices to create and delete
     * device user links. You can only unsuspend or deactivate suspended devices. &gt; **Note:** SUSPENDED status is
     * meant to be temporary, so it isn&#39;t destructive.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void suspendDevice(String deviceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling suspendDevice");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}/lifecycle/suspend".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unsuspend a Device Unsuspends a Device by returning its &#x60;status&#x60; to ACTIVE. &gt;**Note:** Only devices
     * with a SUSPENDED status can be unsuspended.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsuspendDevice(String deviceId) throws ApiException {
        this.unsuspendDevice(deviceId, Collections.emptyMap());
    }

    /**
     * Unsuspend a Device Unsuspends a Device by returning its &#x60;status&#x60; to ACTIVE. &gt;**Note:** Only devices
     * with a SUSPENDED status can be unsuspended.
     *
     * @param deviceId
     *            &#x60;id&#x60; of the device (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsuspendDevice(String deviceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'deviceId' is set
        if (deviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'deviceId' when calling unsuspendDevice");
        }

        // create path and map variables
        String localVarPath = "/api/v1/devices/{deviceId}/lifecycle/unsuspend".replaceAll("\\{" + "deviceId" + "\\}",
                apiClient.escapeString(deviceId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
