/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.BouncesRemoveListObj;
import com.okta.sdk.resource.model.BouncesRemoveListResult;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailCustomizationApi {

    private ApiClient apiClient;

    public EmailCustomizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailCustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Remove Bounced Emails Removes emails from an email service bounce list. The emails submitted in this operation
     * are removed from the bounce list by an asynchronous job. Any email address that passes validation is accepted for
     * the removal process, even if there are other email addresses in the request that failed validation. &gt;
     * **Note:** If there are validation errors for all email addresses, a &#x60;200 OK&#x60; HTTP status is still
     * returned.
     *
     * @param bouncesRemoveListObj
     *            (optional)
     *
     * @return BouncesRemoveListResult
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BouncesRemoveListResult bulkRemoveEmailAddressBounces(BouncesRemoveListObj bouncesRemoveListObj)
            throws ApiException {
        return this.bulkRemoveEmailAddressBounces(bouncesRemoveListObj, Collections.emptyMap());
    }

    /**
     * Remove Bounced Emails Removes emails from an email service bounce list. The emails submitted in this operation
     * are removed from the bounce list by an asynchronous job. Any email address that passes validation is accepted for
     * the removal process, even if there are other email addresses in the request that failed validation. &gt;
     * **Note:** If there are validation errors for all email addresses, a &#x60;200 OK&#x60; HTTP status is still
     * returned.
     *
     * @param bouncesRemoveListObj
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return BouncesRemoveListResult
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public BouncesRemoveListResult bulkRemoveEmailAddressBounces(BouncesRemoveListObj bouncesRemoveListObj,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = bouncesRemoveListObj;

        // create path and map variables
        String localVarPath = "/api/v1/org/email/bounces/remove-list";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<BouncesRemoveListResult> localVarReturnType = new TypeReference<BouncesRemoveListResult>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
