/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.InlineHook;
import com.okta.sdk.resource.model.InlineHookResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class InlineHookApi {

    private ApiClient apiClient;

    public InlineHookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InlineHookApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an Inline Hook Activates the inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook activateInlineHook(String inlineHookId) throws ApiException {
        return this.activateInlineHook(inlineHookId, Collections.emptyMap());
    }

    /**
     * Activate an Inline Hook Activates the inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook activateInlineHook(String inlineHookId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'inlineHookId' when calling activateInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}/lifecycle/activate"
                .replaceAll("\\{" + "inlineHookId" + "\\}", apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an Inline Hook Creates an inline hook
     *
     * @param inlineHook
     *            (required)
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook createInlineHook(InlineHook inlineHook) throws ApiException {
        return this.createInlineHook(inlineHook, Collections.emptyMap());
    }

    /**
     * Create an Inline Hook Creates an inline hook
     *
     * @param inlineHook
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook createInlineHook(InlineHook inlineHook, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = inlineHook;

        // verify the required parameter 'inlineHook' is set
        if (inlineHook == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHook' when calling createInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Inline Hook Deactivates the inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook deactivateInlineHook(String inlineHookId) throws ApiException {
        return this.deactivateInlineHook(inlineHookId, Collections.emptyMap());
    }

    /**
     * Deactivate an Inline Hook Deactivates the inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook deactivateInlineHook(String inlineHookId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'inlineHookId' when calling deactivateInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}/lifecycle/deactivate"
                .replaceAll("\\{" + "inlineHookId" + "\\}", apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an Inline Hook Deletes an inline hook by &#x60;inlineHookId&#x60;. Once deleted, the Inline Hook is
     * unrecoverable. As a safety precaution, only Inline Hooks with a status of INACTIVE are eligible for deletion.
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteInlineHook(String inlineHookId) throws ApiException {
        this.deleteInlineHook(inlineHookId, Collections.emptyMap());
    }

    /**
     * Delete an Inline Hook Deletes an inline hook by &#x60;inlineHookId&#x60;. Once deleted, the Inline Hook is
     * unrecoverable. As a safety precaution, only Inline Hooks with a status of INACTIVE are eligible for deletion.
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteInlineHook(String inlineHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling deleteInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{" + "inlineHookId" + "\\}",
                apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Execute an Inline Hook Executes the inline hook by &#x60;inlineHookId&#x60; using the request body as the input.
     * This will send the provided data through the Channel and return a response if it matches the correct data
     * contract. This execution endpoint should only be used for testing purposes.
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param payloadData
     *            (required)
     *
     * @return InlineHookResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHookResponse executeInlineHook(String inlineHookId, Object payloadData) throws ApiException {
        return this.executeInlineHook(inlineHookId, payloadData, Collections.emptyMap());
    }

    /**
     * Execute an Inline Hook Executes the inline hook by &#x60;inlineHookId&#x60; using the request body as the input.
     * This will send the provided data through the Channel and return a response if it matches the correct data
     * contract. This execution endpoint should only be used for testing purposes.
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param payloadData
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHookResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHookResponse executeInlineHook(String inlineHookId, Object payloadData,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = payloadData;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling executeInlineHook");
        }

        // verify the required parameter 'payloadData' is set
        if (payloadData == null) {
            throw new ApiException(400, "Missing the required parameter 'payloadData' when calling executeInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}/execute".replaceAll("\\{" + "inlineHookId" + "\\}",
                apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHookResponse> localVarReturnType = new TypeReference<InlineHookResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve an Inline Hook Retrieves an inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook getInlineHook(String inlineHookId) throws ApiException {
        return this.getInlineHook(inlineHookId, Collections.emptyMap());
    }

    /**
     * Retrieve an Inline Hook Retrieves an inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook getInlineHook(String inlineHookId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling getInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{" + "inlineHookId" + "\\}",
                apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Inline Hooks Lists all inline hooks
     *
     * @param type
     *            (optional)
     *
     * @return List&lt;InlineHook&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<InlineHook> listInlineHooks(String type) throws ApiException {
        return this.listInlineHooks(type, Collections.emptyMap());
    }

    /**
     * List all Inline Hooks Lists all inline hooks
     *
     * @param type
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;InlineHook&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<InlineHook> listInlineHooks(String type, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<InlineHook>> localVarReturnType = new TypeReference<List<InlineHook>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Inline Hook Replaces an inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param inlineHook
     *            (required)
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook replaceInlineHook(String inlineHookId, InlineHook inlineHook) throws ApiException {
        return this.replaceInlineHook(inlineHookId, inlineHook, Collections.emptyMap());
    }

    /**
     * Replace an Inline Hook Replaces an inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param inlineHook
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook replaceInlineHook(String inlineHookId, InlineHook inlineHook,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = inlineHook;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling replaceInlineHook");
        }

        // verify the required parameter 'inlineHook' is set
        if (inlineHook == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHook' when calling replaceInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{" + "inlineHookId" + "\\}",
                apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update an Inline Hook Updates an inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param inlineHook
     *            (required)
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook updateInlineHook(String inlineHookId, InlineHook inlineHook) throws ApiException {
        return this.updateInlineHook(inlineHookId, inlineHook, Collections.emptyMap());
    }

    /**
     * Update an Inline Hook Updates an inline hook by &#x60;inlineHookId&#x60;
     *
     * @param inlineHookId
     *            &#x60;id&#x60; of the Inline Hook (required)
     * @param inlineHook
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return InlineHook
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public InlineHook updateInlineHook(String inlineHookId, InlineHook inlineHook,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = inlineHook;

        // verify the required parameter 'inlineHookId' is set
        if (inlineHookId == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHookId' when calling updateInlineHook");
        }

        // verify the required parameter 'inlineHook' is set
        if (inlineHook == null) {
            throw new ApiException(400, "Missing the required parameter 'inlineHook' when calling updateInlineHook");
        }

        // create path and map variables
        String localVarPath = "/api/v1/inlineHooks/{inlineHookId}".replaceAll("\\{" + "inlineHookId" + "\\}",
                apiClient.escapeString(inlineHookId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<InlineHook> localVarReturnType = new TypeReference<InlineHook>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
