/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.PrincipalRateLimitEntity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PrincipalRateLimitApi {

    private ApiClient apiClient;

    public PrincipalRateLimitApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PrincipalRateLimitApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Principal Rate Limit Creates a new Principal Rate Limit entity. In the current release, we only allow
     * one Principal Rate Limit entity per org and principal.
     *
     * @param entity
     *            (required)
     *
     * @return PrincipalRateLimitEntity
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PrincipalRateLimitEntity createPrincipalRateLimitEntity(PrincipalRateLimitEntity entity)
            throws ApiException {
        return this.createPrincipalRateLimitEntity(entity, Collections.emptyMap());
    }

    /**
     * Create a Principal Rate Limit Creates a new Principal Rate Limit entity. In the current release, we only allow
     * one Principal Rate Limit entity per org and principal.
     *
     * @param entity
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PrincipalRateLimitEntity
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PrincipalRateLimitEntity createPrincipalRateLimitEntity(PrincipalRateLimitEntity entity,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = entity;

        // verify the required parameter 'entity' is set
        if (entity == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'entity' when calling createPrincipalRateLimitEntity");
        }

        // create path and map variables
        String localVarPath = "/api/v1/principal-rate-limits";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PrincipalRateLimitEntity> localVarReturnType = new TypeReference<PrincipalRateLimitEntity>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Principal Rate Limit Retrieves a Principal Rate Limit entity by &#x60;principalRateLimitId&#x60;
     *
     * @param principalRateLimitId
     *            id of the Principal Rate Limit (required)
     *
     * @return PrincipalRateLimitEntity
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PrincipalRateLimitEntity getPrincipalRateLimitEntity(String principalRateLimitId) throws ApiException {
        return this.getPrincipalRateLimitEntity(principalRateLimitId, Collections.emptyMap());
    }

    /**
     * Retrieve a Principal Rate Limit Retrieves a Principal Rate Limit entity by &#x60;principalRateLimitId&#x60;
     *
     * @param principalRateLimitId
     *            id of the Principal Rate Limit (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PrincipalRateLimitEntity
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PrincipalRateLimitEntity getPrincipalRateLimitEntity(String principalRateLimitId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'principalRateLimitId' is set
        if (principalRateLimitId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'principalRateLimitId' when calling getPrincipalRateLimitEntity");
        }

        // create path and map variables
        String localVarPath = "/api/v1/principal-rate-limits/{principalRateLimitId}".replaceAll(
                "\\{" + "principalRateLimitId" + "\\}", apiClient.escapeString(principalRateLimitId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PrincipalRateLimitEntity> localVarReturnType = new TypeReference<PrincipalRateLimitEntity>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Principal Rate Limits Lists all Principal Rate Limit entities considering the provided parameters
     *
     * @param filter
     *            (optional)
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to 20)
     *
     * @return List&lt;PrincipalRateLimitEntity&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<PrincipalRateLimitEntity> listPrincipalRateLimitEntities(String filter, String after, Integer limit)
            throws ApiException {
        return this.listPrincipalRateLimitEntities(filter, after, limit, Collections.emptyMap());
    }

    /**
     * List all Principal Rate Limits Lists all Principal Rate Limit entities considering the provided parameters
     *
     * @param filter
     *            (optional)
     * @param after
     *            (optional)
     * @param limit
     *            (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;PrincipalRateLimitEntity&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<PrincipalRateLimitEntity> listPrincipalRateLimitEntities(String filter, String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/principal-rate-limits";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<PrincipalRateLimitEntity>> localVarReturnType = new TypeReference<List<PrincipalRateLimitEntity>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Principal Rate Limit Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
     *
     * @param principalRateLimitId
     *            id of the Principal Rate Limit (required)
     * @param entity
     *            (required)
     *
     * @return PrincipalRateLimitEntity
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PrincipalRateLimitEntity replacePrincipalRateLimitEntity(String principalRateLimitId,
            PrincipalRateLimitEntity entity) throws ApiException {
        return this.replacePrincipalRateLimitEntity(principalRateLimitId, entity, Collections.emptyMap());
    }

    /**
     * Replace a Principal Rate Limit Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
     *
     * @param principalRateLimitId
     *            id of the Principal Rate Limit (required)
     * @param entity
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return PrincipalRateLimitEntity
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public PrincipalRateLimitEntity replacePrincipalRateLimitEntity(String principalRateLimitId,
            PrincipalRateLimitEntity entity, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = entity;

        // verify the required parameter 'principalRateLimitId' is set
        if (principalRateLimitId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'principalRateLimitId' when calling replacePrincipalRateLimitEntity");
        }

        // verify the required parameter 'entity' is set
        if (entity == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'entity' when calling replacePrincipalRateLimitEntity");
        }

        // create path and map variables
        String localVarPath = "/api/v1/principal-rate-limits/{principalRateLimitId}".replaceAll(
                "\\{" + "principalRateLimitId" + "\\}", apiClient.escapeString(principalRateLimitId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<PrincipalRateLimitEntity> localVarReturnType = new TypeReference<PrincipalRateLimitEntity>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
