/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.SmsTemplate;
import com.okta.sdk.resource.model.SmsTemplateType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TemplateApi {

    private ApiClient apiClient;

    public TemplateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an SMS Template Creates a new custom SMS template
     *
     * @param smsTemplate
     *            (required)
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate) throws ApiException {
        return this.createSmsTemplate(smsTemplate, Collections.emptyMap());
    }

    /**
     * Create an SMS Template Creates a new custom SMS template
     *
     * @param smsTemplate
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = smsTemplate;

        // verify the required parameter 'smsTemplate' is set
        if (smsTemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
        }

        // create path and map variables
        String localVarPath = "/api/v1/templates/sms";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SmsTemplate> localVarReturnType = new TypeReference<SmsTemplate>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete an SMS Template Deletes an SMS template
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteSmsTemplate(String templateId) throws ApiException {
        this.deleteSmsTemplate(templateId, Collections.emptyMap());
    }

    /**
     * Delete an SMS Template Deletes an SMS template
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteSmsTemplate(String templateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteSmsTemplate");
        }

        // create path and map variables
        String localVarPath = "/api/v1/templates/sms/{templateId}".replaceAll("\\{" + "templateId" + "\\}",
                apiClient.escapeString(templateId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an SMS Template Retrieves a specific template by &#x60;id&#x60;
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate getSmsTemplate(String templateId) throws ApiException {
        return this.getSmsTemplate(templateId, Collections.emptyMap());
    }

    /**
     * Retrieve an SMS Template Retrieves a specific template by &#x60;id&#x60;
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate getSmsTemplate(String templateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling getSmsTemplate");
        }

        // create path and map variables
        String localVarPath = "/api/v1/templates/sms/{templateId}".replaceAll("\\{" + "templateId" + "\\}",
                apiClient.escapeString(templateId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SmsTemplate> localVarReturnType = new TypeReference<SmsTemplate>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all SMS Templates Lists all custom SMS templates. A subset of templates can be returned that match a
     * template type.
     *
     * @param templateType
     *            (optional)
     *
     * @return List&lt;SmsTemplate&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<SmsTemplate> listSmsTemplates(SmsTemplateType templateType) throws ApiException {
        return this.listSmsTemplates(templateType, Collections.emptyMap());
    }

    /**
     * List all SMS Templates Lists all custom SMS templates. A subset of templates can be returned that match a
     * template type.
     *
     * @param templateType
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;SmsTemplate&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<SmsTemplate> listSmsTemplates(SmsTemplateType templateType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/templates/sms";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("templateType", templateType));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<SmsTemplate>> localVarReturnType = new TypeReference<List<SmsTemplate>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an SMS Template Replaces the SMS Template &gt; **Notes:** You can&#39;t update the default SMS Template.
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     * @param smsTemplate
     *            (required)
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate replaceSmsTemplate(String templateId, SmsTemplate smsTemplate) throws ApiException {
        return this.replaceSmsTemplate(templateId, smsTemplate, Collections.emptyMap());
    }

    /**
     * Replace an SMS Template Replaces the SMS Template &gt; **Notes:** You can&#39;t update the default SMS Template.
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     * @param smsTemplate
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate replaceSmsTemplate(String templateId, SmsTemplate smsTemplate,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = smsTemplate;

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
        }

        // verify the required parameter 'smsTemplate' is set
        if (smsTemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
        }

        // create path and map variables
        String localVarPath = "/api/v1/templates/sms/{templateId}".replaceAll("\\{" + "templateId" + "\\}",
                apiClient.escapeString(templateId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SmsTemplate> localVarReturnType = new TypeReference<SmsTemplate>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update an SMS Template Updates only some of the SMS Template properties: * All properties within the custom SMS
     * Template that have values are updated. * Any translation that doesn&#39;t exist is added. * Any translation with
     * a null or empty value is removed. * Any translation with non-empty/null value is updated.
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     * @param smsTemplate
     *            (required)
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate updateSmsTemplate(String templateId, SmsTemplate smsTemplate) throws ApiException {
        return this.updateSmsTemplate(templateId, smsTemplate, Collections.emptyMap());
    }

    /**
     * Update an SMS Template Updates only some of the SMS Template properties: * All properties within the custom SMS
     * Template that have values are updated. * Any translation that doesn&#39;t exist is added. * Any translation with
     * a null or empty value is removed. * Any translation with non-empty/null value is updated.
     *
     * @param templateId
     *            &#x60;id&#x60; of the Template (required)
     * @param smsTemplate
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return SmsTemplate
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public SmsTemplate updateSmsTemplate(String templateId, SmsTemplate smsTemplate,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = smsTemplate;

        // verify the required parameter 'templateId' is set
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
        }

        // verify the required parameter 'smsTemplate' is set
        if (smsTemplate == null) {
            throw new ApiException(400, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
        }

        // create path and map variables
        String localVarPath = "/api/v1/templates/sms/{templateId}".replaceAll("\\{" + "templateId" + "\\}",
                apiClient.escapeString(templateId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<SmsTemplate> localVarReturnType = new TypeReference<SmsTemplate>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
