/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2RefreshToken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserOAuthApi {

    private ApiClient apiClient;

    public UserOAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserOAuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a Refresh Token for a Client Retrieves a refresh Token issued for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     *
     * @return OAuth2RefreshToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId,
            String expand) throws ApiException {
        return this.getRefreshTokenForUserAndClient(userId, clientId, tokenId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve a Refresh Token for a Client Retrieves a refresh Token issued for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2RefreshToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId,
            String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling getRefreshTokenForUserAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling getRefreshTokenForUserAndClient");
        }

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'tokenId' when calling getRefreshTokenForUserAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "tokenId" + "\\}", apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2RefreshToken> localVarReturnType = new TypeReference<OAuth2RefreshToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Refresh Tokens for a Client Lists all refresh Tokens issued for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of tokens to return (optional, default to 20)
     *
     * @return List&lt;OAuth2RefreshToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2RefreshToken> listRefreshTokensForUserAndClient(String userId, String clientId, String expand,
            String after, Integer limit) throws ApiException {
        return this.listRefreshTokensForUserAndClient(userId, clientId, expand, after, limit, Collections.emptyMap());
    }

    /**
     * List all Refresh Tokens for a Client Lists all refresh Tokens issued for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of tokens to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2RefreshToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2RefreshToken> listRefreshTokensForUserAndClient(String userId, String clientId, String expand,
            String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listRefreshTokensForUserAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling listRefreshTokensForUserAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2RefreshToken>> localVarReturnType = new TypeReference<List<OAuth2RefreshToken>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke a Token for a Client Revokes the specified refresh Token
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeTokenForUserAndClient(String userId, String clientId, String tokenId) throws ApiException {
        this.revokeTokenForUserAndClient(userId, clientId, tokenId, Collections.emptyMap());
    }

    /**
     * Revoke a Token for a Client Revokes the specified refresh Token
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param tokenId
     *            &#x60;id&#x60; of Token (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeTokenForUserAndClient(String userId, String clientId, String tokenId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling revokeTokenForUserAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling revokeTokenForUserAndClient");
        }

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'tokenId' when calling revokeTokenForUserAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()))
                .replaceAll("\\{" + "tokenId" + "\\}", apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke all Refresh Tokens for a Client Revokes all refresh Tokens issued for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeTokensForUserAndClient(String userId, String clientId) throws ApiException {
        this.revokeTokensForUserAndClient(userId, clientId, Collections.emptyMap());
    }

    /**
     * Revoke all Refresh Tokens for a Client Revokes all refresh Tokens issued for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeTokensForUserAndClient(String userId, String clientId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling revokeTokensForUserAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling revokeTokensForUserAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
