package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * APNSConfiguration
 */
@JsonPropertyOrder({ APNSConfiguration.JSON_PROPERTY_FILE_NAME, APNSConfiguration.JSON_PROPERTY_KEY_ID,
        APNSConfiguration.JSON_PROPERTY_TEAM_ID, APNSConfiguration.JSON_PROPERTY_TOKEN_SIGNING_KEY })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class APNSConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName;

    public static final String JSON_PROPERTY_KEY_ID = "keyId";
    private String keyId;

    public static final String JSON_PROPERTY_TEAM_ID = "teamId";
    private String teamId;

    public static final String JSON_PROPERTY_TOKEN_SIGNING_KEY = "tokenSigningKey";
    private String tokenSigningKey;

    public APNSConfiguration() {
    }

    public APNSConfiguration fileName(String fileName) {

        this.fileName = fileName;
        return this;
    }

    /**
     * (Optional) File name for Admin Console display
     *
     * @return fileName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "(Optional) File name for Admin Console display")
    @JsonProperty(JSON_PROPERTY_FILE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFileName() {
        return fileName;
    }

    @JsonProperty(JSON_PROPERTY_FILE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public APNSConfiguration keyId(String keyId) {

        this.keyId = keyId;
        return this;
    }

    /**
     * 10-character Key ID obtained from the Apple developer account
     *
     * @return keyId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "10-character Key ID obtained from the Apple developer account")
    @JsonProperty(JSON_PROPERTY_KEY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKeyId() {
        return keyId;
    }

    @JsonProperty(JSON_PROPERTY_KEY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public APNSConfiguration teamId(String teamId) {

        this.teamId = teamId;
        return this;
    }

    /**
     * 10-character Team ID used to develop the iOS app
     *
     * @return teamId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "10-character Team ID used to develop the iOS app")
    @JsonProperty(JSON_PROPERTY_TEAM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTeamId() {
        return teamId;
    }

    @JsonProperty(JSON_PROPERTY_TEAM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public APNSConfiguration tokenSigningKey(String tokenSigningKey) {

        this.tokenSigningKey = tokenSigningKey;
        return this;
    }

    /**
     * APNs private authentication token signing key
     *
     * @return tokenSigningKey
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "APNs private authentication token signing key")
    @JsonProperty(JSON_PROPERTY_TOKEN_SIGNING_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenSigningKey() {
        return tokenSigningKey;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN_SIGNING_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokenSigningKey(String tokenSigningKey) {
        this.tokenSigningKey = tokenSigningKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        APNSConfiguration apNSConfiguration = (APNSConfiguration) o;
        return Objects.equals(this.fileName, apNSConfiguration.fileName)
                && Objects.equals(this.keyId, apNSConfiguration.keyId)
                && Objects.equals(this.teamId, apNSConfiguration.teamId)
                && Objects.equals(this.tokenSigningKey, apNSConfiguration.tokenSigningKey);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(fileName, keyId, teamId, tokenSigningKey);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APNSConfiguration {\n");
        sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
        sb.append("    keyId: ").append(toIndentedString(keyId)).append("\n");
        sb.append("    teamId: ").append(toIndentedString(teamId)).append("\n");
        sb.append("    tokenSigningKey: ").append(toIndentedString(tokenSigningKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
