package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppInstanceContainerStatus;
import com.okta.sdk.resource.model.AppLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Container details for resource type APP_ACCOUNT
 */
@ApiModel(description = "Container details for resource type APP_ACCOUNT")
@JsonPropertyOrder({ AppAccountContainerDetails.JSON_PROPERTY_APP_NAME,
        AppAccountContainerDetails.JSON_PROPERTY_CONTAINER_ID, AppAccountContainerDetails.JSON_PROPERTY_DISPLAY_NAME,
        AppAccountContainerDetails.JSON_PROPERTY_GLOBAL_APP_ID,
        AppAccountContainerDetails.JSON_PROPERTY_PASSWORD_PUSH_SUPPORTED,
        AppAccountContainerDetails.JSON_PROPERTY_PROVISIONING_ENABLED, AppAccountContainerDetails.JSON_PROPERTY_STATUS,
        AppAccountContainerDetails.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AppAccountContainerDetails implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP_NAME = "appName";
    private String appName;

    public static final String JSON_PROPERTY_CONTAINER_ID = "containerId";
    private String containerId;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_GLOBAL_APP_ID = "globalAppId";
    private String globalAppId;

    public static final String JSON_PROPERTY_PASSWORD_PUSH_SUPPORTED = "passwordPushSupported";
    private Boolean passwordPushSupported;

    public static final String JSON_PROPERTY_PROVISIONING_ENABLED = "provisioningEnabled";
    private Boolean provisioningEnabled;

    public static final String JSON_PROPERTY_STATUS = "status";
    private AppInstanceContainerStatus status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private AppLink links;

    public AppAccountContainerDetails() {
    }

    /*
     * @JsonCreator public AppAccountContainerDetails(
     *
     * @JsonProperty(JSON_PROPERTY_APP_NAME) String appName,
     *
     * @JsonProperty(JSON_PROPERTY_DISPLAY_NAME) String displayName,
     *
     * @JsonProperty(JSON_PROPERTY_GLOBAL_APP_ID) String globalAppId,
     *
     * @JsonProperty(JSON_PROPERTY_PASSWORD_PUSH_SUPPORTED) Boolean passwordPushSupported,
     *
     * @JsonProperty(JSON_PROPERTY_PROVISIONING_ENABLED) Boolean provisioningEnabled ) { this(); this.appName = appName;
     * this.displayName = displayName; this.globalAppId = globalAppId; this.passwordPushSupported =
     * passwordPushSupported; this.provisioningEnabled = provisioningEnabled; }
     */

    /**
     * The application name
     *
     * @return appName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "google", value = "The application name")
    @JsonProperty(JSON_PROPERTY_APP_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppName() {
        return appName;
    }

    public AppAccountContainerDetails containerId(String containerId) {

        this.containerId = containerId;
        return this;
    }

    /**
     * The application ID associated with the privileged account
     *
     * @return containerId
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "0oa103099SBEb3Z2b0g4", required = true, value = "The application ID associated with the privileged account")
    @JsonProperty(JSON_PROPERTY_CONTAINER_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getContainerId() {
        return containerId;
    }

    @JsonProperty(JSON_PROPERTY_CONTAINER_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    /**
     * Human-readable name of the container that owns the privileged resource
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Google App1", value = "Human-readable name of the container that owns the privileged resource")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDisplayName() {
        return displayName;
    }

    /**
     * The application global ID
     *
     * @return globalAppId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "964b82aa-85b4-5645-b790-83312c473480", value = "The application global ID")
    @JsonProperty(JSON_PROPERTY_GLOBAL_APP_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getGlobalAppId() {
        return globalAppId;
    }

    /**
     * Indicates if the application supports password push
     *
     * @return passwordPushSupported
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "true", value = "Indicates if the application supports password push")
    @JsonProperty(JSON_PROPERTY_PASSWORD_PUSH_SUPPORTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getPasswordPushSupported() {
        return passwordPushSupported;
    }

    /**
     * Indicates if provisioning is enabled for this application
     *
     * @return provisioningEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "true", value = "Indicates if provisioning is enabled for this application")
    @JsonProperty(JSON_PROPERTY_PROVISIONING_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getProvisioningEnabled() {
        return provisioningEnabled;
    }

    public AppAccountContainerDetails status(AppInstanceContainerStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppInstanceContainerStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(AppInstanceContainerStatus status) {
        this.status = status;
    }

    public AppAccountContainerDetails links(AppLink links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppLink getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AppLink links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppAccountContainerDetails appAccountContainerDetails = (AppAccountContainerDetails) o;
        return Objects.equals(this.appName, appAccountContainerDetails.appName)
                && Objects.equals(this.containerId, appAccountContainerDetails.containerId)
                && Objects.equals(this.displayName, appAccountContainerDetails.displayName)
                && Objects.equals(this.globalAppId, appAccountContainerDetails.globalAppId)
                && Objects.equals(this.passwordPushSupported, appAccountContainerDetails.passwordPushSupported)
                && Objects.equals(this.provisioningEnabled, appAccountContainerDetails.provisioningEnabled)
                && Objects.equals(this.status, appAccountContainerDetails.status)
                && Objects.equals(this.links, appAccountContainerDetails.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appName, containerId, displayName, globalAppId, passwordPushSupported, provisioningEnabled,
                status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppAccountContainerDetails {\n");
        sb.append("    appName: ").append(toIndentedString(appName)).append("\n");
        sb.append("    containerId: ").append(toIndentedString(containerId)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    globalAppId: ").append(toIndentedString(globalAppId)).append("\n");
        sb.append("    passwordPushSupported: ").append(toIndentedString(passwordPushSupported)).append("\n");
        sb.append("    provisioningEnabled: ").append(toIndentedString(provisioningEnabled)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
