package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppCustomHrefObjectHints;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AppCustomHrefObject
 */
@JsonPropertyOrder({ AppCustomHrefObject.JSON_PROPERTY_HINTS, AppCustomHrefObject.JSON_PROPERTY_HREF,
        AppCustomHrefObject.JSON_PROPERTY_TITLE, AppCustomHrefObject.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AppCustomHrefObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HINTS = "hints";
    private AppCustomHrefObjectHints hints;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public AppCustomHrefObject() {
    }

    public AppCustomHrefObject hints(AppCustomHrefObjectHints hints) {

        this.hints = hints;
        return this;
    }

    /**
     * Get hints
     *
     * @return hints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppCustomHrefObjectHints getHints() {
        return hints;
    }

    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHints(AppCustomHrefObjectHints hints) {
        this.hints = hints;
    }

    public AppCustomHrefObject href(String href) {

        this.href = href;
        return this;
    }

    /**
     * Link URI
     *
     * @return href
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Link URI")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHref(String href) {
        this.href = href;
    }

    public AppCustomHrefObject title(String title) {

        this.title = title;
        return this;
    }

    /**
     * Link name
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link name")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public AppCustomHrefObject type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The media type of the link. If omitted, it is implicitly &#x60;application/json&#x60;.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The media type of the link. If omitted, it is implicitly `application/json`.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppCustomHrefObject appCustomHrefObject = (AppCustomHrefObject) o;
        return Objects.equals(this.hints, appCustomHrefObject.hints)
                && Objects.equals(this.href, appCustomHrefObject.href)
                && Objects.equals(this.title, appCustomHrefObject.title)
                && Objects.equals(this.type, appCustomHrefObject.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hints, href, title, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppCustomHrefObject {\n");
        sb.append("    hints: ").append(toIndentedString(hints)).append("\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
