package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Apps with &#x60;BASIC_AUTH&#x60;, &#x60;BROWSER_PLUGIN&#x60;, or &#x60;SECURE_PASSWORD_STORE&#x60; sign-on modes have
 * credentials vaulted by Okta and can be configured with the following schemes.
 */
public enum ApplicationCredentialsScheme {

    ADMIN_SETS_CREDENTIALS("ADMIN_SETS_CREDENTIALS"),

    EDIT_PASSWORD_ONLY("EDIT_PASSWORD_ONLY"),

    EDIT_USERNAME_AND_PASSWORD("EDIT_USERNAME_AND_PASSWORD"),

    EXTERNAL_PASSWORD_SYNC("EXTERNAL_PASSWORD_SYNC"),

    SHARED_USERNAME_AND_PASSWORD("SHARED_USERNAME_AND_PASSWORD"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ApplicationCredentialsScheme(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ApplicationCredentialsScheme fromValue(String value) {
        for (ApplicationCredentialsScheme b : ApplicationCredentialsScheme.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
