package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Embedded resources related to the app using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. If the
 * &#x60;expand&#x3D;user/{userId}&#x60; query parameter is specified, then the assigned [Application
 * User](/openapi/okta-management/management/tag/ApplicationUsers/) is embedded.
 */
@ApiModel(description = "Embedded resources related to the app using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. If the `expand=user/{userId}` query parameter is specified, then the assigned [Application User](/openapi/okta-management/management/tag/ApplicationUsers/) is embedded.")
@JsonPropertyOrder({ ApplicationEmbedded.JSON_PROPERTY_USER })
@JsonTypeName("Application__embedded")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationEmbedded implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_USER = "user";
    private Map<String, Object> user = null;

    public ApplicationEmbedded() {
    }

    public ApplicationEmbedded user(Map<String, Object> user) {

        this.user = user;
        return this;
    }

    public ApplicationEmbedded putuserItem(String key, Object userItem) {
        if (this.user == null) {
            this.user = new HashMap<>();
        }
        this.user.put(key, userItem);
        return this;
    }

    /**
     * The specified [Application User](/openapi/okta-management/management/tag/ApplicationUsers/) assigned to the app
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The specified [Application User](/openapi/okta-management/management/tag/ApplicationUsers/) assigned to the app")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(Map<String, Object> user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationEmbedded applicationEmbedded = (ApplicationEmbedded) o;
        return Objects.equals(this.user, applicationEmbedded.user);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(user);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationEmbedded {\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
