package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationGroupAssignmentLinks;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The Application Group object that defines a group of users&#39; app-specific profile and credentials for an app
 */
@ApiModel(description = "The Application Group object that defines a group of users' app-specific profile and credentials for an app")
@JsonPropertyOrder({ ApplicationGroupAssignment.JSON_PROPERTY_ID, ApplicationGroupAssignment.JSON_PROPERTY_LAST_UPDATED,
        ApplicationGroupAssignment.JSON_PROPERTY_PRIORITY, ApplicationGroupAssignment.JSON_PROPERTY_PROFILE,
        ApplicationGroupAssignment.JSON_PROPERTY_EMBEDDED, ApplicationGroupAssignment.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationGroupAssignment implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private Integer priority;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApplicationGroupAssignmentLinks links;

    public ApplicationGroupAssignment() {
    }

    /*
     * @JsonCreator public ApplicationGroupAssignment(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.id = id; this.embedded =
     * embedded; }
     */

    /**
     * ID of the [Group](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/)
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00g4hb1HChfUriNgW0g4", value = "ID of the [Group](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/)")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public ApplicationGroupAssignment lastUpdated(OffsetDateTime lastUpdated) {

        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * Get lastUpdated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ApplicationGroupAssignment priority(Integer priority) {

        this.priority = priority;
        return this;
    }

    /**
     * Priority assigned to the group. If an app has more than one group assigned to the same user, then the group with
     * the higher priority has its profile applied to the [Application
     * User](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/ApplicationUsers/). If a
     * priority value isn&#39;t specified, then the next highest priority is assigned by default. See [Assign attribute
     * group priority](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-usgp-app-group-priority) and
     * the [sample priority use
     * case](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-usgp-combine-values-use).
     *
     * @return priority
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "99", value = "Priority assigned to the group. If an app has more than one group assigned to the same user, then the group with the higher priority has its profile applied to the [Application User](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/ApplicationUsers/). If a priority value isn't specified, then the next highest priority is assigned by default. See [Assign attribute group priority](https://help.okta.com/okta_help.htm?type=oie&id=ext-usgp-app-group-priority) and the [sample priority use case](https://help.okta.com/okta_help.htm?type=oie&id=ext-usgp-combine-values-use).")
    @JsonProperty(JSON_PROPERTY_PRIORITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getPriority() {
        return priority;
    }

    @JsonProperty(JSON_PROPERTY_PRIORITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ApplicationGroupAssignment profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public ApplicationGroupAssignment putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * Specifies the profile properties applied to [Application
     * Users](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/ApplicationUsers/) that are
     * assigned to the app through group membership. Some reference properties are imported from the target app and
     * can&#39;t be configured. See
     * [profile](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c&#x3D;200&amp;path&#x3D;profile&amp;t&#x3D;response).
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the profile properties applied to [Application Users](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/ApplicationUsers/) that are assigned to the app through group membership.  Some reference properties are imported from the target app and can't be configured. See [profile](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c=200&path=profile&t=response).")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    /**
     * Embedded resource related to the Application Group using the [JSON Hypertext Application
     * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. If the
     * &#x60;expand&#x3D;group&#x60; query parameter is specified, then the
     * [Group](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/) object is embedded. If
     * the &#x60;expand&#x3D;metadata&#x60; query parameter is specified, then the group assignment metadata is
     * embedded.
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Embedded resource related to the Application Group using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. If the `expand=group` query parameter is specified, then the [Group](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Group/) object is embedded.  If the `expand=metadata` query parameter is specified, then the group assignment metadata is embedded.")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public ApplicationGroupAssignment links(ApplicationGroupAssignmentLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationGroupAssignmentLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApplicationGroupAssignmentLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationGroupAssignment applicationGroupAssignment = (ApplicationGroupAssignment) o;
        return Objects.equals(this.id, applicationGroupAssignment.id)
                && Objects.equals(this.lastUpdated, applicationGroupAssignment.lastUpdated)
                && Objects.equals(this.priority, applicationGroupAssignment.priority)
                && Objects.equals(this.profile, applicationGroupAssignment.profile)
                && Objects.equals(this.embedded, applicationGroupAssignment.embedded)
                && Objects.equals(this.links, applicationGroupAssignment.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, lastUpdated, priority, profile, embedded, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationGroupAssignment {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
