package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationLayoutRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ApplicationLayout
 */
@JsonPropertyOrder({ ApplicationLayout.JSON_PROPERTY_ELEMENTS, ApplicationLayout.JSON_PROPERTY_LABEL,
        ApplicationLayout.JSON_PROPERTY_OPTIONS, ApplicationLayout.JSON_PROPERTY_RULE,
        ApplicationLayout.JSON_PROPERTY_SCOPE, ApplicationLayout.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationLayout implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ELEMENTS = "elements";
    private List<Map<String, Object>> elements = null;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_OPTIONS = "options";
    private Map<String, Object> options = null;

    public static final String JSON_PROPERTY_RULE = "rule";
    private ApplicationLayoutRule rule;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public ApplicationLayout() {
    }

    public ApplicationLayout elements(List<Map<String, Object>> elements) {

        this.elements = elements;
        return this;
    }

    public ApplicationLayout addelementsItem(Map<String, Object> elementsItem) {
        if (this.elements == null) {
            this.elements = new ArrayList<>();
        }
        this.elements.add(elementsItem);
        return this;
    }

    /**
     * Get elements
     *
     * @return elements
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ELEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Map<String, Object>> getElements() {
        return elements;
    }

    @JsonProperty(JSON_PROPERTY_ELEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setElements(List<Map<String, Object>> elements) {
        this.elements = elements;
    }

    public ApplicationLayout label(String label) {

        this.label = label;
        return this;
    }

    /**
     * Get label
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public ApplicationLayout options(Map<String, Object> options) {

        this.options = options;
        return this;
    }

    public ApplicationLayout putoptionsItem(String key, Object optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    /**
     * Get options
     *
     * @return options
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OPTIONS)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getOptions() {
        return options;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONS)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public ApplicationLayout rule(ApplicationLayoutRule rule) {

        this.rule = rule;
        return this;
    }

    /**
     * Get rule
     *
     * @return rule
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RULE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLayoutRule getRule() {
        return rule;
    }

    @JsonProperty(JSON_PROPERTY_RULE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRule(ApplicationLayoutRule rule) {
        this.rule = rule;
    }

    public ApplicationLayout scope(String scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Get scope
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public ApplicationLayout type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationLayout applicationLayout = (ApplicationLayout) o;
        return Objects.equals(this.elements, applicationLayout.elements)
                && Objects.equals(this.label, applicationLayout.label)
                && Objects.equals(this.options, applicationLayout.options)
                && Objects.equals(this.rule, applicationLayout.rule)
                && Objects.equals(this.scope, applicationLayout.scope)
                && Objects.equals(this.type, applicationLayout.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(elements, label, options, rule, scope, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationLayout {\n");
        sb.append("    elements: ").append(toIndentedString(elements)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    options: ").append(toIndentedString(options)).append("\n");
        sb.append("    rule: ").append(toIndentedString(rule)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
