package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * App notes visible to either the admin or end user
 */
@ApiModel(description = "App notes visible to either the admin or end user")
@JsonPropertyOrder({ ApplicationSettingsNotes.JSON_PROPERTY_ADMIN, ApplicationSettingsNotes.JSON_PROPERTY_ENDUSER })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationSettingsNotes implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ADMIN = "admin";
    private String admin;

    public static final String JSON_PROPERTY_ENDUSER = "enduser";
    private String enduser;

    public ApplicationSettingsNotes() {
    }

    public ApplicationSettingsNotes admin(String admin) {

        this.admin = admin;
        return this;
    }

    /**
     * An app message that&#39;s visible to admins
     *
     * @return admin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An app message that's visible to admins")
    @JsonProperty(JSON_PROPERTY_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAdmin() {
        return admin;
    }

    @JsonProperty(JSON_PROPERTY_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public ApplicationSettingsNotes enduser(String enduser) {

        this.enduser = enduser;
        return this;
    }

    /**
     * A message that&#39;s visible in the End-User Dashboard
     *
     * @return enduser
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A message that's visible in the End-User Dashboard")
    @JsonProperty(JSON_PROPERTY_ENDUSER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEnduser() {
        return enduser;
    }

    @JsonProperty(JSON_PROPERTY_ENDUSER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnduser(String enduser) {
        this.enduser = enduser;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationSettingsNotes applicationSettingsNotes = (ApplicationSettingsNotes) o;
        return Objects.equals(this.admin, applicationSettingsNotes.admin)
                && Objects.equals(this.enduser, applicationSettingsNotes.enduser);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(admin, enduser);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationSettingsNotes {\n");
        sb.append("    admin: ").append(toIndentedString(admin)).append("\n");
        sb.append("    enduser: ").append(toIndentedString(enduser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
