package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines network zones for VPN notification
 */
@ApiModel(description = "Defines network zones for VPN notification")
@JsonPropertyOrder({ ApplicationSettingsNotificationsVpnNetwork.JSON_PROPERTY_CONNECTION,
        ApplicationSettingsNotificationsVpnNetwork.JSON_PROPERTY_EXCLUDE,
        ApplicationSettingsNotificationsVpnNetwork.JSON_PROPERTY_INCLUDE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ApplicationSettingsNotificationsVpnNetwork implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Specifies the VPN connection details required to access the app
     */
    public enum ConnectionEnum {
        DISABLED("DISABLED"),

        ANYWHERE("ANYWHERE"),

        ON_NETWORK("ON_NETWORK"),

        OFF_NETWORK("OFF_NETWORK"),

        ZONE("ZONE"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ConnectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ConnectionEnum fromValue(String value) {
            for (ConnectionEnum b : ConnectionEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private ConnectionEnum connection;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public ApplicationSettingsNotificationsVpnNetwork() {
    }

    public ApplicationSettingsNotificationsVpnNetwork connection(ConnectionEnum connection) {

        this.connection = connection;
        return this;
    }

    /**
     * Specifies the VPN connection details required to access the app
     *
     * @return connection
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the VPN connection details required to access the app")
    @JsonProperty(JSON_PROPERTY_CONNECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ConnectionEnum getConnection() {
        return connection;
    }

    @JsonProperty(JSON_PROPERTY_CONNECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(ConnectionEnum connection) {
        this.connection = connection;
    }

    public ApplicationSettingsNotificationsVpnNetwork exclude(List<String> exclude) {

        this.exclude = exclude;
        return this;
    }

    public ApplicationSettingsNotificationsVpnNetwork addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * Defines the IP addresses or network ranges that are excluded from the VPN requirement
     *
     * @return exclude
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Defines the IP addresses or network ranges that are excluded from the VPN requirement")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public ApplicationSettingsNotificationsVpnNetwork include(List<String> include) {

        this.include = include;
        return this;
    }

    public ApplicationSettingsNotificationsVpnNetwork addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * Defines the IP addresses or network ranges that are required to use the VPN
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Defines the IP addresses or network ranges that are required to use the VPN")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationSettingsNotificationsVpnNetwork applicationSettingsNotificationsVpnNetwork = (ApplicationSettingsNotificationsVpnNetwork) o;
        return Objects.equals(this.connection, applicationSettingsNotificationsVpnNetwork.connection)
                && Objects.equals(this.exclude, applicationSettingsNotificationsVpnNetwork.exclude)
                && Objects.equals(this.include, applicationSettingsNotificationsVpnNetwork.include);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(connection, exclude, include);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationSettingsNotificationsVpnNetwork {\n");
        sb.append("    connection: ").append(toIndentedString(connection)).append("\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
