package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticationMethod
 */
@JsonPropertyOrder({ AuthenticationMethod.JSON_PROPERTY_HARDWARE_PROTECTION, AuthenticationMethod.JSON_PROPERTY_ID,
        AuthenticationMethod.JSON_PROPERTY_KEY, AuthenticationMethod.JSON_PROPERTY_METHOD,
        AuthenticationMethod.JSON_PROPERTY_PHISHING_RESISTANT, AuthenticationMethod.JSON_PROPERTY_USER_VERIFICATION })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticationMethod implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Indicates if any secrets or private keys used during authentication must be hardware protected and not
     * exportable. This property is only set for &#x60;POSSESSION&#x60; constraints.
     */
    public enum HardwareProtectionEnum {
        OPTIONAL("OPTIONAL"),

        REQUIRED("REQUIRED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        HardwareProtectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static HardwareProtectionEnum fromValue(String value) {
            for (HardwareProtectionEnum b : HardwareProtectionEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_HARDWARE_PROTECTION = "hardwareProtection";
    private HardwareProtectionEnum hardwareProtection = HardwareProtectionEnum.OPTIONAL;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_KEY = "key";
    private String key;

    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;

    /**
     * Indicates if phishing-resistant Factors are required. This property is only set for &#x60;POSSESSION&#x60;
     * constraints
     */
    public enum PhishingResistantEnum {
        OPTIONAL("OPTIONAL"),

        REQUIRED("REQUIRED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        PhishingResistantEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static PhishingResistantEnum fromValue(String value) {
            for (PhishingResistantEnum b : PhishingResistantEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_PHISHING_RESISTANT = "phishingResistant";
    private PhishingResistantEnum phishingResistant = PhishingResistantEnum.OPTIONAL;

    /**
     * Indicates the user interaction requirement (PIN or biometrics) to ensure verification of a possession factor
     */
    public enum UserVerificationEnum {
        OPTIONAL("OPTIONAL"),

        REQUIRED("REQUIRED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        UserVerificationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static UserVerificationEnum fromValue(String value) {
            for (UserVerificationEnum b : UserVerificationEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
    private UserVerificationEnum userVerification = UserVerificationEnum.OPTIONAL;

    public AuthenticationMethod() {
    }

    public AuthenticationMethod hardwareProtection(HardwareProtectionEnum hardwareProtection) {

        this.hardwareProtection = hardwareProtection;
        return this;
    }

    /**
     * Indicates if any secrets or private keys used during authentication must be hardware protected and not
     * exportable. This property is only set for &#x60;POSSESSION&#x60; constraints.
     *
     * @return hardwareProtection
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if any secrets or private keys used during authentication must be hardware protected and not exportable. This property is only set for `POSSESSION` constraints.")
    @JsonProperty(JSON_PROPERTY_HARDWARE_PROTECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HardwareProtectionEnum getHardwareProtection() {
        return hardwareProtection;
    }

    @JsonProperty(JSON_PROPERTY_HARDWARE_PROTECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHardwareProtection(HardwareProtectionEnum hardwareProtection) {
        this.hardwareProtection = hardwareProtection;
    }

    public AuthenticationMethod id(String id) {

        this.id = id;
        return this;
    }

    /**
     * An ID that identifies the authenticator
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An ID that identifies the authenticator")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AuthenticationMethod key(String key) {

        this.key = key;
        return this;
    }

    /**
     * A label that identifies the authenticator
     *
     * @return key
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "A label that identifies the authenticator")
    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getKey() {
        return key;
    }

    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setKey(String key) {
        this.key = key;
    }

    public AuthenticationMethod method(String method) {

        this.method = method;
        return this;
    }

    /**
     * Specifies the method used for the authenticator
     *
     * @return method
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Specifies the method used for the authenticator")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setMethod(String method) {
        this.method = method;
    }

    public AuthenticationMethod phishingResistant(PhishingResistantEnum phishingResistant) {

        this.phishingResistant = phishingResistant;
        return this;
    }

    /**
     * Indicates if phishing-resistant Factors are required. This property is only set for &#x60;POSSESSION&#x60;
     * constraints
     *
     * @return phishingResistant
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if phishing-resistant Factors are required. This property is only set for `POSSESSION` constraints")
    @JsonProperty(JSON_PROPERTY_PHISHING_RESISTANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PhishingResistantEnum getPhishingResistant() {
        return phishingResistant;
    }

    @JsonProperty(JSON_PROPERTY_PHISHING_RESISTANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPhishingResistant(PhishingResistantEnum phishingResistant) {
        this.phishingResistant = phishingResistant;
    }

    public AuthenticationMethod userVerification(UserVerificationEnum userVerification) {

        this.userVerification = userVerification;
        return this;
    }

    /**
     * Indicates the user interaction requirement (PIN or biometrics) to ensure verification of a possession factor
     *
     * @return userVerification
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates the user interaction requirement (PIN or biometrics) to ensure verification of a possession factor")
    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserVerificationEnum getUserVerification() {
        return userVerification;
    }

    @JsonProperty(JSON_PROPERTY_USER_VERIFICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethod authenticationMethod = (AuthenticationMethod) o;
        return Objects.equals(this.hardwareProtection, authenticationMethod.hardwareProtection)
                && Objects.equals(this.id, authenticationMethod.id)
                && Objects.equals(this.key, authenticationMethod.key)
                && Objects.equals(this.method, authenticationMethod.method)
                && Objects.equals(this.phishingResistant, authenticationMethod.phishingResistant)
                && Objects.equals(this.userVerification, authenticationMethod.userVerification);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hardwareProtection, id, key, method, phishingResistant, userVerification);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethod {\n");
        sb.append("    hardwareProtection: ").append(toIndentedString(hardwareProtection)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("    phishingResistant: ").append(toIndentedString(phishingResistant)).append("\n");
        sb.append("    userVerification: ").append(toIndentedString(userVerification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
