package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticationMethodChain;
import com.okta.sdk.resource.model.PolicyRuleVerificationMethodType;
import com.okta.sdk.resource.model.VerificationMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticationMethodChainMethod
 */
@JsonPropertyOrder({ AuthenticationMethodChainMethod.JSON_PROPERTY_CHAINS,
        AuthenticationMethodChainMethod.JSON_PROPERTY_REAUTHENTICATE_IN })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = AuthenticationMethodChainMethod.class)

public class AuthenticationMethodChainMethod extends VerificationMethod implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CHAINS = "chains";
    private List<AuthenticationMethodChain> chains = null;

    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;

    public AuthenticationMethodChainMethod() {
    }

    public AuthenticationMethodChainMethod chains(List<AuthenticationMethodChain> chains) {

        this.chains = chains;
        return this;
    }

    public AuthenticationMethodChainMethod addchainsItem(AuthenticationMethodChain chainsItem) {
        if (this.chains == null) {
            this.chains = new ArrayList<>();
        }
        this.chains.add(chainsItem);
        return this;
    }

    /**
     * Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps.
     *
     * @return chains
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps.")
    @JsonProperty(JSON_PROPERTY_CHAINS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticationMethodChain> getChains() {
        return chains;
    }

    @JsonProperty(JSON_PROPERTY_CHAINS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setChains(List<AuthenticationMethodChain> chains) {
        this.chains = chains;
    }

    public AuthenticationMethodChainMethod reauthenticateIn(String reauthenticateIn) {

        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    /**
     * Specifies how often the user should be prompted for authentication using duration format for the time period. For
     * example, &#x60;PT2H30M&#x60; for two and a half hours. Don&#39;t set this parameter if you&#39;re setting the
     * &#x60;reauthenticateIn&#x60; parameter in &#x60;chains&#x60;.
     *
     * @return reauthenticateIn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies how often the user should be prompted for authentication using duration format for the time period.  For example, `PT2H30M` for two and a half hours. Don't set this parameter if you're setting the `reauthenticateIn` parameter in `chains`.")
    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReauthenticateIn() {
        return reauthenticateIn;
    }

    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethodChainMethod authenticationMethodChainMethod = (AuthenticationMethodChainMethod) o;
        return Objects.equals(this.chains, authenticationMethodChainMethod.chains)
                && Objects.equals(this.reauthenticateIn, authenticationMethodChainMethod.reauthenticateIn);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(chains, reauthenticateIn, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethodChainMethod {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    chains: ").append(toIndentedString(chains)).append("\n");
        sb.append("    reauthenticateIn: ").append(toIndentedString(reauthenticateIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
