package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticationMethodObject
 */
@JsonPropertyOrder({ AuthenticationMethodObject.JSON_PROPERTY_KEY, AuthenticationMethodObject.JSON_PROPERTY_METHOD })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticationMethodObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_KEY = "key";
    private String key;

    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;

    public AuthenticationMethodObject() {
    }

    public AuthenticationMethodObject key(String key) {

        this.key = key;
        return this;
    }

    /**
     * A label that identifies the authenticator
     *
     * @return key
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "A label that identifies the authenticator")
    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getKey() {
        return key;
    }

    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setKey(String key) {
        this.key = key;
    }

    public AuthenticationMethodObject method(String method) {

        this.method = method;
        return this;
    }

    /**
     * Specifies the method used for the authenticator
     *
     * @return method
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the method used for the authenticator")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethodObject authenticationMethodObject = (AuthenticationMethodObject) o;
        return Objects.equals(this.key, authenticationMethodObject.key)
                && Objects.equals(this.method, authenticationMethodObject.method);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, method);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethodObject {\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
