package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorKeyCustomAppAllOfProviderConfigurationApns
 */
@JsonPropertyOrder({ AuthenticatorKeyCustomAppAllOfProviderConfigurationApns.JSON_PROPERTY_ID,
        AuthenticatorKeyCustomAppAllOfProviderConfigurationApns.JSON_PROPERTY_APP_BUNDLE_ID,
        AuthenticatorKeyCustomAppAllOfProviderConfigurationApns.JSON_PROPERTY_DEBUG_APP_BUNDLE_ID })
@JsonTypeName("AuthenticatorKeyCustomApp_allOf_provider_configuration_apns")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticatorKeyCustomAppAllOfProviderConfigurationApns implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_APP_BUNDLE_ID = "appBundleId";
    private String appBundleId;

    public static final String JSON_PROPERTY_DEBUG_APP_BUNDLE_ID = "debugAppBundleId";
    private String debugAppBundleId;

    public AuthenticatorKeyCustomAppAllOfProviderConfigurationApns() {
    }

    public AuthenticatorKeyCustomAppAllOfProviderConfigurationApns id(String id) {

        this.id = id;
        return this;
    }

    /**
     * ID of the APNs (Apple Push Notification Service)
     * [configurations](https://developer.okta.com/docs/reference/api/push-providers/)
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the APNs (Apple Push Notification Service) [configurations](https://developer.okta.com/docs/reference/api/push-providers/)")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AuthenticatorKeyCustomAppAllOfProviderConfigurationApns appBundleId(String appBundleId) {

        this.appBundleId = appBundleId;
        return this;
    }

    /**
     * AppBundleId of the APNs (Apple Push Notification Service)
     * [configurations](https://developer.okta.com/docs/reference/api/push-providers/)
     *
     * @return appBundleId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "AppBundleId of the APNs (Apple Push Notification Service) [configurations](https://developer.okta.com/docs/reference/api/push-providers/)")
    @JsonProperty(JSON_PROPERTY_APP_BUNDLE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppBundleId() {
        return appBundleId;
    }

    @JsonProperty(JSON_PROPERTY_APP_BUNDLE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppBundleId(String appBundleId) {
        this.appBundleId = appBundleId;
    }

    public AuthenticatorKeyCustomAppAllOfProviderConfigurationApns debugAppBundleId(String debugAppBundleId) {

        this.debugAppBundleId = debugAppBundleId;
        return this;
    }

    /**
     * DebugAppBundleId of the APNs (Apple Push Notification Service)
     * [configurations](https://developer.okta.com/docs/reference/api/push-providers/)
     *
     * @return debugAppBundleId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "DebugAppBundleId of the APNs (Apple Push Notification Service) [configurations](https://developer.okta.com/docs/reference/api/push-providers/)")
    @JsonProperty(JSON_PROPERTY_DEBUG_APP_BUNDLE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDebugAppBundleId() {
        return debugAppBundleId;
    }

    @JsonProperty(JSON_PROPERTY_DEBUG_APP_BUNDLE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDebugAppBundleId(String debugAppBundleId) {
        this.debugAppBundleId = debugAppBundleId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorKeyCustomAppAllOfProviderConfigurationApns authenticatorKeyCustomAppAllOfProviderConfigurationApns = (AuthenticatorKeyCustomAppAllOfProviderConfigurationApns) o;
        return Objects.equals(this.id, authenticatorKeyCustomAppAllOfProviderConfigurationApns.id)
                && Objects.equals(this.appBundleId, authenticatorKeyCustomAppAllOfProviderConfigurationApns.appBundleId)
                && Objects.equals(this.debugAppBundleId,
                        authenticatorKeyCustomAppAllOfProviderConfigurationApns.debugAppBundleId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, appBundleId, debugAppBundleId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorKeyCustomAppAllOfProviderConfigurationApns {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    appBundleId: ").append(toIndentedString(appBundleId)).append("\n");
        sb.append("    debugAppBundleId: ").append(toIndentedString(debugAppBundleId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
