package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorIdentity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Limits the authenticators that can be used for a given method. Currently, only the &#x60;otp&#x60; method supports
 * constraints, and Google authenticator (key : &#39;google_otp&#39;) is the only allowed authenticator.
 */
@ApiModel(description = "Limits the authenticators that can be used for a given method. Currently, only the `otp` method supports constraints, and Google authenticator (key : 'google_otp') is the only allowed authenticator.")
@JsonPropertyOrder({ AuthenticatorMethodConstraint.JSON_PROPERTY_ALLOWED_AUTHENTICATORS,
        AuthenticatorMethodConstraint.JSON_PROPERTY_METHOD })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticatorMethodConstraint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALLOWED_AUTHENTICATORS = "allowedAuthenticators";
    private List<AuthenticatorIdentity> allowedAuthenticators = null;

    /**
     * Gets or Sets method
     */
    public enum MethodEnum {
        OTP("otp"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;

    public AuthenticatorMethodConstraint() {
    }

    public AuthenticatorMethodConstraint allowedAuthenticators(List<AuthenticatorIdentity> allowedAuthenticators) {

        this.allowedAuthenticators = allowedAuthenticators;
        return this;
    }

    public AuthenticatorMethodConstraint addallowedAuthenticatorsItem(AuthenticatorIdentity allowedAuthenticatorsItem) {
        if (this.allowedAuthenticators == null) {
            this.allowedAuthenticators = new ArrayList<>();
        }
        this.allowedAuthenticators.add(allowedAuthenticatorsItem);
        return this;
    }

    /**
     * Get allowedAuthenticators
     *
     * @return allowedAuthenticators
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALLOWED_AUTHENTICATORS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorIdentity> getAllowedAuthenticators() {
        return allowedAuthenticators;
    }

    @JsonProperty(JSON_PROPERTY_ALLOWED_AUTHENTICATORS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedAuthenticators(List<AuthenticatorIdentity> allowedAuthenticators) {
        this.allowedAuthenticators = allowedAuthenticators;
    }

    public AuthenticatorMethodConstraint method(MethodEnum method) {

        this.method = method;
        return this;
    }

    /**
     * Get method
     *
     * @return method
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public MethodEnum getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodConstraint authenticatorMethodConstraint = (AuthenticatorMethodConstraint) o;
        return Objects.equals(this.allowedAuthenticators, authenticatorMethodConstraint.allowedAuthenticators)
                && Objects.equals(this.method, authenticatorMethodConstraint.method);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowedAuthenticators, method);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodConstraint {\n");
        sb.append("    allowedAuthenticators: ").append(toIndentedString(allowedAuthenticators)).append("\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
