package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PasswordCredential;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ChangePasswordRequest
 */
@JsonPropertyOrder({ ChangePasswordRequest.JSON_PROPERTY_NEW_PASSWORD, ChangePasswordRequest.JSON_PROPERTY_OLD_PASSWORD,
        ChangePasswordRequest.JSON_PROPERTY_REVOKE_SESSIONS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ChangePasswordRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NEW_PASSWORD = "newPassword";
    private PasswordCredential newPassword;

    public static final String JSON_PROPERTY_OLD_PASSWORD = "oldPassword";
    private PasswordCredential oldPassword;

    public static final String JSON_PROPERTY_REVOKE_SESSIONS = "revokeSessions";
    private Boolean revokeSessions = false;

    public ChangePasswordRequest() {
    }

    public ChangePasswordRequest newPassword(PasswordCredential newPassword) {

        this.newPassword = newPassword;
        return this;
    }

    /**
     * Get newPassword
     *
     * @return newPassword
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NEW_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordCredential getNewPassword() {
        return newPassword;
    }

    @JsonProperty(JSON_PROPERTY_NEW_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNewPassword(PasswordCredential newPassword) {
        this.newPassword = newPassword;
    }

    public ChangePasswordRequest oldPassword(PasswordCredential oldPassword) {

        this.oldPassword = oldPassword;
        return this;
    }

    /**
     * Get oldPassword
     *
     * @return oldPassword
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OLD_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordCredential getOldPassword() {
        return oldPassword;
    }

    @JsonProperty(JSON_PROPERTY_OLD_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOldPassword(PasswordCredential oldPassword) {
        this.oldPassword = oldPassword;
    }

    public ChangePasswordRequest revokeSessions(Boolean revokeSessions) {

        this.revokeSessions = revokeSessions;
        return this;
    }

    /**
     * When set to &#x60;true&#x60;, revokes all User sessions, except for the current session
     *
     * @return revokeSessions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "When set to `true`, revokes all User sessions, except for the current session")
    @JsonProperty(JSON_PROPERTY_REVOKE_SESSIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRevokeSessions() {
        return revokeSessions;
    }

    @JsonProperty(JSON_PROPERTY_REVOKE_SESSIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRevokeSessions(Boolean revokeSessions) {
        this.revokeSessions = revokeSessions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ChangePasswordRequest changePasswordRequest = (ChangePasswordRequest) o;
        return Objects.equals(this.newPassword, changePasswordRequest.newPassword)
                && Objects.equals(this.oldPassword, changePasswordRequest.oldPassword)
                && Objects.equals(this.revokeSessions, changePasswordRequest.revokeSessions);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(newPassword, oldPassword, revokeSessions);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangePasswordRequest {\n");
        sb.append("    newPassword: ").append(toIndentedString(newPassword)).append("\n");
        sb.append("    oldPassword: ").append(toIndentedString(oldPassword)).append("\n");
        sb.append("    revokeSessions: ").append(toIndentedString(revokeSessions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
