package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The org setting that assigns the super admin role by default to a public client app
 */
@ApiModel(description = "The org setting that assigns the super admin role by default to a public client app")
@JsonPropertyOrder({ ClientPrivilegesSetting.JSON_PROPERTY_CLIENT_PRIVILEGES_SETTING })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ClientPrivilegesSetting implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_PRIVILEGES_SETTING = "clientPrivilegesSetting";
    private Boolean clientPrivilegesSetting;

    public ClientPrivilegesSetting() {
    }

    public ClientPrivilegesSetting clientPrivilegesSetting(Boolean clientPrivilegesSetting) {

        this.clientPrivilegesSetting = clientPrivilegesSetting;
        return this;
    }

    /**
     * If true, assigns the super admin role by default to new public client apps
     *
     * @return clientPrivilegesSetting
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "true", value = "If true, assigns the super admin role by default to new public client apps")
    @JsonProperty(JSON_PROPERTY_CLIENT_PRIVILEGES_SETTING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getClientPrivilegesSetting() {
        return clientPrivilegesSetting;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_PRIVILEGES_SETTING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientPrivilegesSetting(Boolean clientPrivilegesSetting) {
        this.clientPrivilegesSetting = clientPrivilegesSetting;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClientPrivilegesSetting clientPrivilegesSetting = (ClientPrivilegesSetting) o;
        return Objects.equals(this.clientPrivilegesSetting, clientPrivilegesSetting.clientPrivilegesSetting);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientPrivilegesSetting);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientPrivilegesSetting {\n");
        sb.append("    clientPrivilegesSetting: ").append(toIndentedString(clientPrivilegesSetting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
