package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Type of encryption used on the device &gt; **Note:** The following values map to Disk Encryption ON:
 * &#x60;FULL&#x60;, &#x60;USER&#x60;, &#x60;ALL_INTERNAL_VOLUMES&#x60;. All other values map to Disk Encryption OFF.
 */
public enum DiskEncryptionTypeDef {

    ALL_INTERNAL_VOLUMES("ALL_INTERNAL_VOLUMES"),

    FULL("FULL"),

    NONE("NONE"),

    SYSTEM_VOLUME("SYSTEM_VOLUME"),

    USER("USER"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    DiskEncryptionTypeDef(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static DiskEncryptionTypeDef fromValue(String value) {
        for (DiskEncryptionTypeDef b : DiskEncryptionTypeDef.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
