package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailServerResponse
 */
@JsonPropertyOrder({ EmailServerResponse.JSON_PROPERTY_ALIAS, EmailServerResponse.JSON_PROPERTY_ENABLED,
        EmailServerResponse.JSON_PROPERTY_HOST, EmailServerResponse.JSON_PROPERTY_PORT,
        EmailServerResponse.JSON_PROPERTY_USERNAME, EmailServerResponse.JSON_PROPERTY_ID })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailServerResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;

    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;

    public static final String JSON_PROPERTY_HOST = "host";
    private String host;

    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public EmailServerResponse() {
    }

    public EmailServerResponse alias(String alias) {

        this.alias = alias;
        return this;
    }

    /**
     * Human-readable name for your SMTP server
     *
     * @return alias
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "CustomServer1", value = "Human-readable name for your SMTP server")
    @JsonProperty(JSON_PROPERTY_ALIAS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAlias() {
        return alias;
    }

    @JsonProperty(JSON_PROPERTY_ALIAS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlias(String alias) {
        this.alias = alias;
    }

    public EmailServerResponse enabled(Boolean enabled) {

        this.enabled = enabled;
        return this;
    }

    /**
     * If &#x60;true&#x60;, routes all email traffic through your SMTP server
     *
     * @return enabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If `true`, routes all email traffic through your SMTP server")
    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getEnabled() {
        return enabled;
    }

    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public EmailServerResponse host(String host) {

        this.host = host;
        return this;
    }

    /**
     * Hostname or IP address of your SMTP server
     *
     * @return host
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "192.168.160.1", value = "Hostname or IP address of your SMTP server")
    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getHost() {
        return host;
    }

    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHost(String host) {
        this.host = host;
    }

    public EmailServerResponse port(Integer port) {

        this.port = port;
        return this;
    }

    /**
     * Port number of your SMTP server
     *
     * @return port
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "587", value = "Port number of your SMTP server")
    @JsonProperty(JSON_PROPERTY_PORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getPort() {
        return port;
    }

    @JsonProperty(JSON_PROPERTY_PORT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public EmailServerResponse username(String username) {

        this.username = username;
        return this;
    }

    /**
     * Username used to access your SMTP server
     *
     * @return username
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "aUser", value = "Username used to access your SMTP server")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public EmailServerResponse id(String id) {

        this.id = id;
        return this;
    }

    /**
     * ID of your SMTP server
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of your SMTP server")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailServerResponse emailServerResponse = (EmailServerResponse) o;
        return Objects.equals(this.alias, emailServerResponse.alias)
                && Objects.equals(this.enabled, emailServerResponse.enabled)
                && Objects.equals(this.host, emailServerResponse.host)
                && Objects.equals(this.port, emailServerResponse.port)
                && Objects.equals(this.username, emailServerResponse.username)
                && Objects.equals(this.id, emailServerResponse.id);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alias, enabled, host, port, username, id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailServerResponse {\n");
        sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
        sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
        sb.append("    host: ").append(toIndentedString(host)).append("\n");
        sb.append("    port: ").append(toIndentedString(port)).append("\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
