package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ECKeyJWK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Enrollment Initialization Request
 */
@ApiModel(description = "Enrollment Initialization Request")
@JsonPropertyOrder({ EnrollmentInitializationRequest.JSON_PROPERTY_ENROLLMENT_RP_IDS,
        EnrollmentInitializationRequest.JSON_PROPERTY_FULFILLMENT_PROVIDER,
        EnrollmentInitializationRequest.JSON_PROPERTY_USER_ID,
        EnrollmentInitializationRequest.JSON_PROPERTY_YUBICO_TRANSPORT_KEY_J_W_K })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EnrollmentInitializationRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ENROLLMENT_RP_IDS = "enrollmentRpIds";
    private List<String> enrollmentRpIds = null;

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     */
    public enum FulfillmentProviderEnum {
        YUBICO("yubico"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public static final String JSON_PROPERTY_YUBICO_TRANSPORT_KEY_J_W_K = "yubicoTransportKeyJWK";
    private ECKeyJWK yubicoTransportKeyJWK;

    public EnrollmentInitializationRequest() {
    }

    public EnrollmentInitializationRequest enrollmentRpIds(List<String> enrollmentRpIds) {

        this.enrollmentRpIds = enrollmentRpIds;
        return this;
    }

    public EnrollmentInitializationRequest addenrollmentRpIdsItem(String enrollmentRpIdsItem) {
        if (this.enrollmentRpIds == null) {
            this.enrollmentRpIds = new ArrayList<>();
        }
        this.enrollmentRpIds.add(enrollmentRpIdsItem);
        return this;
    }

    /**
     * List of Relying Party hostnames to register on the YubiKey.
     *
     * @return enrollmentRpIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of Relying Party hostnames to register on the YubiKey.")
    @JsonProperty(JSON_PROPERTY_ENROLLMENT_RP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getEnrollmentRpIds() {
        return enrollmentRpIds;
    }

    @JsonProperty(JSON_PROPERTY_ENROLLMENT_RP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnrollmentRpIds(List<String> enrollmentRpIds) {
        this.enrollmentRpIds = enrollmentRpIds;
    }

    public EnrollmentInitializationRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {

        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     *
     * @return fulfillmentProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentProviderEnum getFulfillmentProvider() {
        return fulfillmentProvider;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentInitializationRequest userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * ID of an existing Okta user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of an existing Okta user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public EnrollmentInitializationRequest yubicoTransportKeyJWK(ECKeyJWK yubicoTransportKeyJWK) {

        this.yubicoTransportKeyJWK = yubicoTransportKeyJWK;
        return this;
    }

    /**
     * Get yubicoTransportKeyJWK
     *
     * @return yubicoTransportKeyJWK
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_YUBICO_TRANSPORT_KEY_J_W_K)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ECKeyJWK getYubicoTransportKeyJWK() {
        return yubicoTransportKeyJWK;
    }

    @JsonProperty(JSON_PROPERTY_YUBICO_TRANSPORT_KEY_J_W_K)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setYubicoTransportKeyJWK(ECKeyJWK yubicoTransportKeyJWK) {
        this.yubicoTransportKeyJWK = yubicoTransportKeyJWK;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrollmentInitializationRequest enrollmentInitializationRequest = (EnrollmentInitializationRequest) o;
        return Objects.equals(this.enrollmentRpIds, enrollmentInitializationRequest.enrollmentRpIds)
                && Objects.equals(this.fulfillmentProvider, enrollmentInitializationRequest.fulfillmentProvider)
                && Objects.equals(this.userId, enrollmentInitializationRequest.userId)
                && Objects.equals(this.yubicoTransportKeyJWK, enrollmentInitializationRequest.yubicoTransportKeyJWK);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enrollmentRpIds, fulfillmentProvider, userId, yubicoTransportKeyJWK);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentInitializationRequest {\n");
        sb.append("    enrollmentRpIds: ").append(toIndentedString(enrollmentRpIds)).append("\n");
        sb.append("    fulfillmentProvider: ").append(toIndentedString(fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    yubicoTransportKeyJWK: ").append(toIndentedString(yubicoTransportKeyJWK)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
