package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ErrorCause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Error
 */
@JsonPropertyOrder({ Error.JSON_PROPERTY_ERROR_CAUSES, Error.JSON_PROPERTY_ERROR_CODE, Error.JSON_PROPERTY_ERROR_ID,
        Error.JSON_PROPERTY_ERROR_LINK, Error.JSON_PROPERTY_ERROR_SUMMARY })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Error implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_CAUSES = "errorCauses";
    private List<ErrorCause> errorCauses = null;

    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;

    public static final String JSON_PROPERTY_ERROR_ID = "errorId";
    private String errorId;

    public static final String JSON_PROPERTY_ERROR_LINK = "errorLink";
    private String errorLink;

    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public Error() {
    }

    public Error errorCauses(List<ErrorCause> errorCauses) {

        this.errorCauses = errorCauses;
        return this;
    }

    public Error adderrorCausesItem(ErrorCause errorCausesItem) {
        if (this.errorCauses == null) {
            this.errorCauses = new ArrayList<>();
        }
        this.errorCauses.add(errorCausesItem);
        return this;
    }

    /**
     * Get errorCauses
     *
     * @return errorCauses
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ERROR_CAUSES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<ErrorCause> getErrorCauses() {
        return errorCauses;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_CAUSES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCauses(List<ErrorCause> errorCauses) {
        this.errorCauses = errorCauses;
    }

    public Error errorCode(String errorCode) {

        this.errorCode = errorCode;
        return this;
    }

    /**
     * An Okta code for this type of error
     *
     * @return errorCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An Okta code for this type of error")
    @JsonProperty(JSON_PROPERTY_ERROR_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorCode() {
        return errorCode;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Error errorId(String errorId) {

        this.errorId = errorId;
        return this;
    }

    /**
     * A unique identifier for this error. This can be used by Okta Support to help with troubleshooting.
     *
     * @return errorId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A unique identifier for this error. This can be used by Okta Support to help with troubleshooting.")
    @JsonProperty(JSON_PROPERTY_ERROR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorId() {
        return errorId;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    public Error errorLink(String errorLink) {

        this.errorLink = errorLink;
        return this;
    }

    /**
     * An Okta code for this type of error
     *
     * @return errorLink
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An Okta code for this type of error")
    @JsonProperty(JSON_PROPERTY_ERROR_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorLink() {
        return errorLink;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorLink(String errorLink) {
        this.errorLink = errorLink;
    }

    public Error errorSummary(String errorSummary) {

        this.errorSummary = errorSummary;
        return this;
    }

    /**
     * A short description of what caused this error. Sometimes this contains dynamically-generated information about
     * your specific error.
     *
     * @return errorSummary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A short description of what caused this error. Sometimes this contains dynamically-generated information about your specific error.")
    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorSummary() {
        return errorSummary;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error) o;
        return Objects.equals(this.errorCauses, error.errorCauses) && Objects.equals(this.errorCode, error.errorCode)
                && Objects.equals(this.errorId, error.errorId) && Objects.equals(this.errorLink, error.errorLink)
                && Objects.equals(this.errorSummary, error.errorSummary);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorCauses, errorCode, errorId, errorLink, errorSummary);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    errorCauses: ").append(toIndentedString(errorCauses)).append("\n");
        sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
        sb.append("    errorId: ").append(toIndentedString(errorId)).append("\n");
        sb.append("    errorLink: ").append(toIndentedString(errorLink)).append("\n");
        sb.append("    errorSummary: ").append(toIndentedString(errorSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
