package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * [Discoverable
 * resources](/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!c&#x3D;200&amp;path&#x3D;_links&amp;t&#x3D;response)
 * related to the Group
 */
@ApiModel(description = "[Discoverable resources](/openapi/okta-management/management/tag/Group/#tag/Group/operation/listGroups!c=200&path=_links&t=response) related to the Group")
@JsonPropertyOrder({ GroupLinks.JSON_PROPERTY_SELF, GroupLinks.JSON_PROPERTY_APPS, GroupLinks.JSON_PROPERTY_LOGO,
        GroupLinks.JSON_PROPERTY_SOURCE, GroupLinks.JSON_PROPERTY_USERS })
@JsonTypeName("Group__links")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_APPS = "apps";
    private HrefObject apps;

    public static final String JSON_PROPERTY_LOGO = "logo";
    private List<HrefObject> logo = null;

    public static final String JSON_PROPERTY_SOURCE = "source";
    private HrefObject source;

    public static final String JSON_PROPERTY_USERS = "users";
    private HrefObject users;

    public GroupLinks() {
    }

    public GroupLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public GroupLinks apps(HrefObject apps) {

        this.apps = apps;
        return this;
    }

    /**
     * Get apps
     *
     * @return apps
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getApps() {
        return apps;
    }

    @JsonProperty(JSON_PROPERTY_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApps(HrefObject apps) {
        this.apps = apps;
    }

    public GroupLinks logo(List<HrefObject> logo) {

        this.logo = logo;
        return this;
    }

    public GroupLinks addlogoItem(HrefObject logoItem) {
        if (this.logo == null) {
            this.logo = new ArrayList<>();
        }
        this.logo.add(logoItem);
        return this;
    }

    /**
     * Get logo
     *
     * @return logo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<HrefObject> getLogo() {
        return logo;
    }

    @JsonProperty(JSON_PROPERTY_LOGO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogo(List<HrefObject> logo) {
        this.logo = logo;
    }

    public GroupLinks source(HrefObject source) {

        this.source = source;
        return this;
    }

    /**
     * Get source
     *
     * @return source
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getSource() {
        return source;
    }

    @JsonProperty(JSON_PROPERTY_SOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSource(HrefObject source) {
        this.source = source;
    }

    public GroupLinks users(HrefObject users) {

        this.users = users;
        return this;
    }

    /**
     * Get users
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(HrefObject users) {
        this.users = users;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupLinks groupLinks = (GroupLinks) o;
        return Objects.equals(this.self, groupLinks.self) && Objects.equals(this.apps, groupLinks.apps)
                && Objects.equals(this.logo, groupLinks.logo) && Objects.equals(this.source, groupLinks.source)
                && Objects.equals(this.users, groupLinks.users);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, apps, logo, source, users);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    apps: ").append(toIndentedString(apps)).append("\n");
        sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
