package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupOwnerOriginType;
import com.okta.sdk.resource.model.GroupOwnerType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * GroupOwner
 */
@JsonPropertyOrder({ GroupOwner.JSON_PROPERTY_DISPLAY_NAME, GroupOwner.JSON_PROPERTY_ID,
        GroupOwner.JSON_PROPERTY_LAST_UPDATED, GroupOwner.JSON_PROPERTY_ORIGIN_ID, GroupOwner.JSON_PROPERTY_ORIGIN_TYPE,
        GroupOwner.JSON_PROPERTY_RESOLVED, GroupOwner.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupOwner implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_ORIGIN_ID = "originId";
    private String originId;

    public static final String JSON_PROPERTY_ORIGIN_TYPE = "originType";
    private GroupOwnerOriginType originType;

    public static final String JSON_PROPERTY_RESOLVED = "resolved";
    private Boolean resolved;

    public static final String JSON_PROPERTY_TYPE = "type";
    private GroupOwnerType type;

    public GroupOwner() {
    }

    /*
     * @JsonCreator public GroupOwner(
     *
     * @JsonProperty(JSON_PROPERTY_DISPLAY_NAME) String displayName,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.displayName = displayName;
     * this.lastUpdated = lastUpdated; }
     */

    /**
     * The display name of the group owner
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The display name of the group owner")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDisplayName() {
        return displayName;
    }

    public GroupOwner id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The &#x60;id&#x60; of the group owner
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `id` of the group owner")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Timestamp when the group owner was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the group owner was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public GroupOwner originId(String originId) {

        this.originId = originId;
        return this;
    }

    /**
     * The ID of the app instance if the &#x60;originType&#x60; is &#x60;APPLICATION&#x60;. This value is
     * &#x60;NULL&#x60; if &#x60;originType&#x60; is &#x60;OKTA_DIRECTORY&#x60;.
     *
     * @return originId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the app instance if the `originType` is `APPLICATION`. This value is `NULL` if `originType` is `OKTA_DIRECTORY`.")
    @JsonProperty(JSON_PROPERTY_ORIGIN_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOriginId() {
        return originId;
    }

    @JsonProperty(JSON_PROPERTY_ORIGIN_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public GroupOwner originType(GroupOwnerOriginType originType) {

        this.originType = originType;
        return this;
    }

    /**
     * Get originType
     *
     * @return originType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupOwnerOriginType getOriginType() {
        return originType;
    }

    @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOriginType(GroupOwnerOriginType originType) {
        this.originType = originType;
    }

    public GroupOwner resolved(Boolean resolved) {

        this.resolved = resolved;
        return this;
    }

    /**
     * If &#x60;originType&#x60;is APPLICATION, this parameter is set to &#x60;FALSE&#x60; until the owner’s
     * &#x60;originId&#x60; is reconciled with an associated Okta ID.
     *
     * @return resolved
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If `originType`is APPLICATION, this parameter is set to `FALSE` until the owner’s `originId` is reconciled with an associated Okta ID.")
    @JsonProperty(JSON_PROPERTY_RESOLVED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getResolved() {
        return resolved;
    }

    @JsonProperty(JSON_PROPERTY_RESOLVED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public GroupOwner type(GroupOwnerType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupOwnerType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(GroupOwnerType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupOwner groupOwner = (GroupOwner) o;
        return Objects.equals(this.displayName, groupOwner.displayName) && Objects.equals(this.id, groupOwner.id)
                && Objects.equals(this.lastUpdated, groupOwner.lastUpdated)
                && Objects.equals(this.originId, groupOwner.originId)
                && Objects.equals(this.originType, groupOwner.originType)
                && Objects.equals(this.resolved, groupOwner.resolved) && Objects.equals(this.type, groupOwner.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(displayName, id, lastUpdated, originId, originType, resolved, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupOwner {\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    originId: ").append(toIndentedString(originId)).append("\n");
        sb.append("    originType: ").append(toIndentedString(originType)).append("\n");
        sb.append("    resolved: ").append(toIndentedString(resolved)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
