package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OktaActiveDirectoryGroupProfile;
import com.okta.sdk.resource.model.OktaUserGroupProfile;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies required and optional properties for a Group. The &#x60;objectClass&#x60; of a Group determines which
 * additional properties are available. You can extend Group Profiles with custom properties, but you must first add the
 * properties to the Group Profile schema before you can reference them. Use the Profile Editor in the Admin Console or
 * the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Schema/)to manage schema
 * extensions. Custom properties can contain HTML tags. It is the client&#39;s responsibility to escape or encode this
 * data before displaying it. Use
 * [best-practices](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) to
 * prevent cross-site scripting.
 */
@ApiModel(description = "Specifies required and optional properties for a Group. The `objectClass` of a Group determines which additional properties are available.  You can extend Group Profiles with custom properties, but you must first add the properties to the Group Profile schema before you can reference them. Use the Profile Editor in the Admin Console or the [Schemas API](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Schema/)to manage schema extensions.  Custom properties can contain HTML tags. It is the client's responsibility to escape or encode this data before displaying it. Use [best-practices](https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html) to prevent cross-site scripting.")
@JsonPropertyOrder({ GroupProfile.JSON_PROPERTY_DESCRIPTION, GroupProfile.JSON_PROPERTY_NAME,
        GroupProfile.JSON_PROPERTY_DN, GroupProfile.JSON_PROPERTY_EXTERNAL_ID,
        GroupProfile.JSON_PROPERTY_SAM_ACCOUNT_NAME, GroupProfile.JSON_PROPERTY_WINDOWS_DOMAIN_QUALIFIED_NAME })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_DN = "dn";
    private String dn;

    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;

    public static final String JSON_PROPERTY_SAM_ACCOUNT_NAME = "samAccountName";
    private String samAccountName;

    public static final String JSON_PROPERTY_WINDOWS_DOMAIN_QUALIFIED_NAME = "windowsDomainQualifiedName";
    private String windowsDomainQualifiedName;

    public GroupProfile() {
    }

    public GroupProfile description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Windows Group
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "example.com/West Coast/West Coast Users", value = "Description of the Windows Group")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public GroupProfile name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Windows Group
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "West Coast Users", value = "Name of the Windows Group")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public GroupProfile dn(String dn) {

        this.dn = dn;
        return this;
    }

    /**
     * The distinguished name of the Windows Group
     *
     * @return dn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "CN=West Coast Users,OU=West Coast,DC=example,DC=com", value = "The distinguished name of the Windows Group")
    @JsonProperty(JSON_PROPERTY_DN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDn() {
        return dn;
    }

    @JsonProperty(JSON_PROPERTY_DN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDn(String dn) {
        this.dn = dn;
    }

    public GroupProfile externalId(String externalId) {

        this.externalId = externalId;
        return this;
    }

    /**
     * Base-64 encoded GUID (&#x60;objectGUID&#x60;) of the Windows Group
     *
     * @return externalId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "VKzYZ1C+IkSZxIWlrW5ITg==", value = "Base-64 encoded GUID (`objectGUID`) of the Windows Group")
    @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExternalId() {
        return externalId;
    }

    @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public GroupProfile samAccountName(String samAccountName) {

        this.samAccountName = samAccountName;
        return this;
    }

    /**
     * Pre-Windows 2000 name of the Windows Group
     *
     * @return samAccountName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "West Coast Users", value = "Pre-Windows 2000 name of the Windows Group")
    @JsonProperty(JSON_PROPERTY_SAM_ACCOUNT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSamAccountName() {
        return samAccountName;
    }

    @JsonProperty(JSON_PROPERTY_SAM_ACCOUNT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSamAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
    }

    public GroupProfile windowsDomainQualifiedName(String windowsDomainQualifiedName) {

        this.windowsDomainQualifiedName = windowsDomainQualifiedName;
        return this;
    }

    /**
     * Fully qualified name of the Windows Group
     *
     * @return windowsDomainQualifiedName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "EXAMPLE\\\\West Coast Users", value = "Fully qualified name of the Windows Group")
    @JsonProperty(JSON_PROPERTY_WINDOWS_DOMAIN_QUALIFIED_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getWindowsDomainQualifiedName() {
        return windowsDomainQualifiedName;
    }

    @JsonProperty(JSON_PROPERTY_WINDOWS_DOMAIN_QUALIFIED_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsDomainQualifiedName(String windowsDomainQualifiedName) {
        this.windowsDomainQualifiedName = windowsDomainQualifiedName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupProfile groupProfile = (GroupProfile) o;
        return Objects.equals(this.description, groupProfile.description)
                && Objects.equals(this.name, groupProfile.name) && Objects.equals(this.dn, groupProfile.dn)
                && Objects.equals(this.externalId, groupProfile.externalId)
                && Objects.equals(this.samAccountName, groupProfile.samAccountName)
                && Objects.equals(this.windowsDomainQualifiedName, groupProfile.windowsDomainQualifiedName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, name, dn, externalId, samAccountName, windowsDomainQualifiedName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupProfile {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    dn: ").append(toIndentedString(dn)).append("\n");
        sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
        sb.append("    samAccountName: ").append(toIndentedString(samAccountName)).append("\n");
        sb.append("    windowsDomainQualifiedName: ").append(toIndentedString(windowsDomainQualifiedName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
