package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupRuleAction;
import com.okta.sdk.resource.model.GroupRuleConditions;
import com.okta.sdk.resource.model.GroupRuleStatus;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * GroupRule
 */
@JsonPropertyOrder({ GroupRule.JSON_PROPERTY_ACTIONS, GroupRule.JSON_PROPERTY_CONDITIONS,
        GroupRule.JSON_PROPERTY_CREATED, GroupRule.JSON_PROPERTY_ID, GroupRule.JSON_PROPERTY_LAST_UPDATED,
        GroupRule.JSON_PROPERTY_NAME, GroupRule.JSON_PROPERTY_STATUS, GroupRule.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupRule implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private GroupRuleAction actions;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private GroupRuleConditions conditions;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private GroupRuleStatus status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public GroupRule() {
    }

    /*
     * @JsonCreator public GroupRule(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    public GroupRule actions(GroupRuleAction actions) {

        this.actions = actions;
        return this;
    }

    /**
     * Get actions
     *
     * @return actions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleAction getActions() {
        return actions;
    }

    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActions(GroupRuleAction actions) {
        this.actions = actions;
    }

    public GroupRule conditions(GroupRuleConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(GroupRuleConditions conditions) {
        this.conditions = conditions;
    }

    /**
     * Creation date for group rule
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Creation date for group rule")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * ID of the group rule
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the group rule")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Date group rule was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Date group rule was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public GroupRule name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Group rule
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Group rule")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public GroupRule status(GroupRuleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(GroupRuleStatus status) {
        this.status = status;
    }

    public GroupRule type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Type to indicate a Group rule operation. Only &#x60;group_rule&#x60; is allowed.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type to indicate a Group rule operation. Only `group_rule` is allowed.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupRule groupRule = (GroupRule) o;
        return Objects.equals(this.actions, groupRule.actions) && Objects.equals(this.conditions, groupRule.conditions)
                && Objects.equals(this.created, groupRule.created) && Objects.equals(this.id, groupRule.id)
                && Objects.equals(this.lastUpdated, groupRule.lastUpdated) && Objects.equals(this.name, groupRule.name)
                && Objects.equals(this.status, groupRule.status) && Objects.equals(this.type, groupRule.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(actions, conditions, created, id, lastUpdated, name, status, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupRule {\n");
        sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
