package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdpPolicyRuleActionMatchCriteria
 */
@JsonPropertyOrder({ IdpPolicyRuleActionMatchCriteria.JSON_PROPERTY_PROPERTY_NAME,
        IdpPolicyRuleActionMatchCriteria.JSON_PROPERTY_PROVIDER_EXPRESSION })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class IdpPolicyRuleActionMatchCriteria implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROPERTY_NAME = "propertyName";
    private String propertyName;

    public static final String JSON_PROPERTY_PROVIDER_EXPRESSION = "providerExpression";
    private String providerExpression;

    public IdpPolicyRuleActionMatchCriteria() {
    }

    public IdpPolicyRuleActionMatchCriteria propertyName(String propertyName) {

        this.propertyName = propertyName;
        return this;
    }

    /**
     * The IdP property that the evaluated string should match to
     *
     * @return propertyName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The IdP property that the evaluated string should match to")
    @JsonProperty(JSON_PROPERTY_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPropertyName() {
        return propertyName;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public IdpPolicyRuleActionMatchCriteria providerExpression(String providerExpression) {

        this.providerExpression = providerExpression;
        return this;
    }

    /**
     * You can provide an Okta Expression Language expression with the Login Context that&#39;s evaluated with the IdP.
     * For example, the value &#x60;login.identifier&#x60; refers to the user&#39;s username. If the user is signing in
     * with the username &#x60;john.doe@mycompany.com&#x60;, the expression
     * &#x60;login.identifier.substringAfter(@))&#x60; is evaluated to the domain name of the user, for example:
     * &#x60;mycompany.com&#x60;.
     *
     * @return providerExpression
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "You can provide an Okta Expression Language expression with the Login Context that's evaluated with the IdP. For example, the value `login.identifier` refers to the user's username. If the user is signing in with the username `john.doe@mycompany.com`, the expression `login.identifier.substringAfter(@))` is evaluated to the domain name of the user, for example: `mycompany.com`. ")
    @JsonProperty(JSON_PROPERTY_PROVIDER_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProviderExpression() {
        return providerExpression;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProviderExpression(String providerExpression) {
        this.providerExpression = providerExpression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdpPolicyRuleActionMatchCriteria idpPolicyRuleActionMatchCriteria = (IdpPolicyRuleActionMatchCriteria) o;
        return Objects.equals(this.propertyName, idpPolicyRuleActionMatchCriteria.propertyName)
                && Objects.equals(this.providerExpression, idpPolicyRuleActionMatchCriteria.providerExpression);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(propertyName, providerExpression);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdpPolicyRuleActionMatchCriteria {\n");
        sb.append("    propertyName: ").append(toIndentedString(propertyName)).append("\n");
        sb.append("    providerExpression: ").append(toIndentedString(providerExpression)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
