package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectAppLink;
import com.okta.sdk.resource.model.HrefObjectGroupLink;
import com.okta.sdk.resource.model.HrefObjectUserLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON
 * Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This
 * object is used for dynamic discovery of resources related to the Application User.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for dynamic discovery of resources related to the Application User.")
@JsonPropertyOrder({ LinksAppAndUser.JSON_PROPERTY_APP, LinksAppAndUser.JSON_PROPERTY_GROUP,
        LinksAppAndUser.JSON_PROPERTY_USER })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LinksAppAndUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP = "app";
    private HrefObjectAppLink app;

    public static final String JSON_PROPERTY_GROUP = "group";
    private HrefObjectGroupLink group;

    public static final String JSON_PROPERTY_USER = "user";
    private HrefObjectUserLink user;

    public LinksAppAndUser() {
    }

    public LinksAppAndUser app(HrefObjectAppLink app) {

        this.app = app;
        return this;
    }

    /**
     * Get app
     *
     * @return app
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectAppLink getApp() {
        return app;
    }

    @JsonProperty(JSON_PROPERTY_APP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApp(HrefObjectAppLink app) {
        this.app = app;
    }

    public LinksAppAndUser group(HrefObjectGroupLink group) {

        this.group = group;
        return this;
    }

    /**
     * Get group
     *
     * @return group
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectGroupLink getGroup() {
        return group;
    }

    @JsonProperty(JSON_PROPERTY_GROUP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroup(HrefObjectGroupLink group) {
        this.group = group;
    }

    public LinksAppAndUser user(HrefObjectUserLink user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectUserLink getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(HrefObjectUserLink user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinksAppAndUser linksAppAndUser = (LinksAppAndUser) o;
        return Objects.equals(this.app, linksAppAndUser.app) && Objects.equals(this.group, linksAppAndUser.group)
                && Objects.equals(this.user, linksAppAndUser.user);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(app, group, user);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinksAppAndUser {\n");
        sb.append("    app: ").append(toIndentedString(app)).append("\n");
        sb.append("    group: ").append(toIndentedString(group)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
