package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Describes the user, app, client, or other entity (actor) who performs an action on a target. The actor is dependent
 * on the action that is performed. All events have actors.
 */
@ApiModel(description = "Describes the user, app, client, or other entity (actor) who performs an action on a target. The actor is dependent on the action that is performed. All events have actors.")
@JsonPropertyOrder({ LogActor.JSON_PROPERTY_ALTERNATE_ID, LogActor.JSON_PROPERTY_DETAIL_ENTRY,
        LogActor.JSON_PROPERTY_DISPLAY_NAME, LogActor.JSON_PROPERTY_ID, LogActor.JSON_PROPERTY_TYPE })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogActor implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALTERNATE_ID = "alternateId";
    private String alternateId;

    public static final String JSON_PROPERTY_DETAIL_ENTRY = "detailEntry";
    private Map<String, Object> detailEntry = null;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public LogActor() {
    }

    /*
     * @JsonCreator public LogActor(
     *
     * @JsonProperty(JSON_PROPERTY_ALTERNATE_ID) String alternateId,
     *
     * @JsonProperty(JSON_PROPERTY_DETAIL_ENTRY) Map<String, Object> detailEntry,
     *
     * @JsonProperty(JSON_PROPERTY_DISPLAY_NAME) String displayName,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.alternateId = alternateId; this.detailEntry =
     * detailEntry; this.displayName = displayName; this.id = id; this.type = type; }
     */

    /**
     * Alternative ID of the actor
     *
     * @return alternateId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Alternative ID of the actor")
    @JsonProperty(JSON_PROPERTY_ALTERNATE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAlternateId() {
        return alternateId;
    }

    /**
     * Further details about the actor
     *
     * @return detailEntry
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Further details about the actor")
    @JsonProperty(JSON_PROPERTY_DETAIL_ENTRY)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getDetailEntry() {
        return detailEntry;
    }

    /**
     * Display name of the actor
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Display name of the actor")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDisplayName() {
        return displayName;
    }

    /**
     * ID of the actor
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the actor")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Type of actor
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of actor")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogActor logActor = (LogActor) o;
        return Objects.equals(this.alternateId, logActor.alternateId)
                && Objects.equals(this.detailEntry, logActor.detailEntry)
                && Objects.equals(this.displayName, logActor.displayName) && Objects.equals(this.id, logActor.id)
                && Objects.equals(this.type, logActor.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alternateId, detailEntry, displayName, id, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogActor {\n");
        sb.append("    alternateId: ").append(toIndentedString(alternateId)).append("\n");
        sb.append("    detailEntry: ").append(toIndentedString(detailEntry)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
