package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The latitude and longitude of the geolocation where an action was performed. The object is formatted according to the
 * [ISO-6709](https://www.iso.org/obp/ui/fr/#iso:std:iso:6709:ed-3:v1:en) standard.
 */
@ApiModel(description = "The latitude and longitude of the geolocation where an action was performed. The object is formatted according to the [ISO-6709](https://www.iso.org/obp/ui/fr/#iso:std:iso:6709:ed-3:v1:en) standard.")
@JsonPropertyOrder({ LogGeolocation.JSON_PROPERTY_LAT, LogGeolocation.JSON_PROPERTY_LON })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogGeolocation implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LAT = "lat";
    private Double lat;

    public static final String JSON_PROPERTY_LON = "lon";
    private Double lon;

    public LogGeolocation() {
    }

    /*
     * @JsonCreator public LogGeolocation(
     *
     * @JsonProperty(JSON_PROPERTY_LAT) Double lat,
     *
     * @JsonProperty(JSON_PROPERTY_LON) Double lon ) { this(); this.lat = lat; this.lon = lon; }
     */

    /**
     * Latitude which uses two digits for the [integer
     * part](https://www.iso.org/obp/ui/fr/#iso:std:iso:6709:ed-3:v1:en#Latitude)
     *
     * @return lat
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Latitude which uses two digits for the [integer part](https://www.iso.org/obp/ui/fr/#iso:std:iso:6709:ed-3:v1:en#Latitude)")
    @JsonProperty(JSON_PROPERTY_LAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Double getLat() {
        return lat;
    }

    /**
     * Longitude which uses three digits for the [integer
     * part](https://www.iso.org/obp/ui/fr/#iso:std:iso:6709:ed-3:v1:en#Longitude)
     *
     * @return lon
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Longitude which uses three digits for the [integer part](https://www.iso.org/obp/ui/fr/#iso:std:iso:6709:ed-3:v1:en#Longitude)")
    @JsonProperty(JSON_PROPERTY_LON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Double getLon() {
        return lon;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogGeolocation logGeolocation = (LogGeolocation) o;
        return Objects.equals(this.lat, logGeolocation.lat) && Objects.equals(this.lon, logGeolocation.lon);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(lat, lon);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogGeolocation {\n");
        sb.append("    lat: ").append(toIndentedString(lat)).append("\n");
        sb.append("    lon: ").append(toIndentedString(lon)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
