package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LogStreamLinksSelfAndLifecycle;
import com.okta.sdk.resource.model.LogStreamType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * LogStream
 */
@JsonPropertyOrder({ LogStream.JSON_PROPERTY_CREATED, LogStream.JSON_PROPERTY_ID, LogStream.JSON_PROPERTY_LAST_UPDATED,
        LogStream.JSON_PROPERTY_NAME, LogStream.JSON_PROPERTY_STATUS, LogStream.JSON_PROPERTY_TYPE,
        LogStream.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = LogStream.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = LogStreamAws.class, name = "aws_eventbridge"),
        @JsonSubTypes.Type(value = LogStreamSplunk.class, name = "splunk_cloud_logstreaming"), })

public class LogStream implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    /**
     * Lifecycle status of the Log Stream object
     */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),

        INACTIVE("INACTIVE"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_TYPE = "type";
    protected LogStreamType type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LogStreamLinksSelfAndLifecycle links;

    public LogStream() {
    }

    /*
     * @JsonCreator public LogStream(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_STATUS) StatusEnum status ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.status = status; }
     */

    /**
     * Timestamp when the Log Stream object was created
     *
     * @return created
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "2022-10-21T16:59:59Z", required = true, value = "Timestamp when the Log Stream object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique identifier for the Log Stream
     *
     * @return id
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "0oa1orzg0CHSgPcjZ0g4", required = true, value = "Unique identifier for the Log Stream")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Log Stream object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "2022-10-21T17:15:10Z", required = true, value = "Timestamp when the Log Stream object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public LogStream name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Unique name for the Log Stream object
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "My AWS EventBridge log stream", required = true, value = "Unique name for the Log Stream object")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Lifecycle status of the Log Stream object
     *
     * @return status
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Lifecycle status of the Log Stream object")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public StatusEnum getStatus() {
        return status;
    }

    public LogStream type(LogStreamType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LogStreamType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(LogStreamType type) {
        this.type = type;
    }

    public LogStream links(LogStreamLinksSelfAndLifecycle links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LogStreamLinksSelfAndLifecycle getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLinks(LogStreamLinksSelfAndLifecycle links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogStream logStream = (LogStream) o;
        return Objects.equals(this.created, logStream.created) && Objects.equals(this.id, logStream.id)
                && Objects.equals(this.lastUpdated, logStream.lastUpdated) && Objects.equals(this.name, logStream.name)
                && Objects.equals(this.status, logStream.status) && Objects.equals(this.type, logStream.type)
                && Objects.equals(this.links, logStream.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, name, status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStream {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
