package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.OAuth2ClaimConditions;
import com.okta.sdk.resource.model.OAuth2ClaimGroupFilterType;
import com.okta.sdk.resource.model.OAuth2ClaimType;
import com.okta.sdk.resource.model.OAuth2ClaimValueType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2Claim
 */
@JsonPropertyOrder({ OAuth2Claim.JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN, OAuth2Claim.JSON_PROPERTY_CLAIM_TYPE,
        OAuth2Claim.JSON_PROPERTY_CONDITIONS, OAuth2Claim.JSON_PROPERTY_GROUP_FILTER_TYPE, OAuth2Claim.JSON_PROPERTY_ID,
        OAuth2Claim.JSON_PROPERTY_NAME, OAuth2Claim.JSON_PROPERTY_STATUS, OAuth2Claim.JSON_PROPERTY_SYSTEM,
        OAuth2Claim.JSON_PROPERTY_VALUE, OAuth2Claim.JSON_PROPERTY_VALUE_TYPE, OAuth2Claim.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuth2Claim implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN = "alwaysIncludeInToken";
    private Boolean alwaysIncludeInToken;

    public static final String JSON_PROPERTY_CLAIM_TYPE = "claimType";
    private OAuth2ClaimType claimType;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private OAuth2ClaimConditions conditions;

    public static final String JSON_PROPERTY_GROUP_FILTER_TYPE = "group_filter_type";
    private OAuth2ClaimGroupFilterType groupFilterType;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_SYSTEM = "system";
    private Boolean system;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public static final String JSON_PROPERTY_VALUE_TYPE = "valueType";
    private OAuth2ClaimValueType valueType;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public OAuth2Claim() {
    }

    /*
     * @JsonCreator public OAuth2Claim(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    public OAuth2Claim alwaysIncludeInToken(Boolean alwaysIncludeInToken) {

        this.alwaysIncludeInToken = alwaysIncludeInToken;
        return this;
    }

    /**
     * Specifies whether to include Claims in the token. The value is always &#x60;TRUE&#x60; for access token Claims.
     * If the value is set to &#x60;FALSE&#x60; for an ID token claim, the Claim isn&#39;t included in the ID token when
     * the token is requested with the access token or with the &#x60;authorization_code&#x60;. The client instead uses
     * the access token to get Claims from the &#x60;/userinfo&#x60; endpoint.
     *
     * @return alwaysIncludeInToken
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies whether to include Claims in the token. The value is always `TRUE` for access token Claims. If the value is set to `FALSE` for an ID token claim, the Claim isn't included in the ID token when the token is requested with the access token or with the `authorization_code`. The client instead uses the access token to get Claims from the `/userinfo` endpoint.")
    @JsonProperty(JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getAlwaysIncludeInToken() {
        return alwaysIncludeInToken;
    }

    @JsonProperty(JSON_PROPERTY_ALWAYS_INCLUDE_IN_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlwaysIncludeInToken(Boolean alwaysIncludeInToken) {
        this.alwaysIncludeInToken = alwaysIncludeInToken;
    }

    public OAuth2Claim claimType(OAuth2ClaimType claimType) {

        this.claimType = claimType;
        return this;
    }

    /**
     * Get claimType
     *
     * @return claimType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLAIM_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimType getClaimType() {
        return claimType;
    }

    @JsonProperty(JSON_PROPERTY_CLAIM_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClaimType(OAuth2ClaimType claimType) {
        this.claimType = claimType;
    }

    public OAuth2Claim conditions(OAuth2ClaimConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(OAuth2ClaimConditions conditions) {
        this.conditions = conditions;
    }

    public OAuth2Claim groupFilterType(OAuth2ClaimGroupFilterType groupFilterType) {

        this.groupFilterType = groupFilterType;
        return this;
    }

    /**
     * Get groupFilterType
     *
     * @return groupFilterType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUP_FILTER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimGroupFilterType getGroupFilterType() {
        return groupFilterType;
    }

    @JsonProperty(JSON_PROPERTY_GROUP_FILTER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroupFilterType(OAuth2ClaimGroupFilterType groupFilterType) {
        this.groupFilterType = groupFilterType;
    }

    /**
     * ID of the Claim
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the Claim")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public OAuth2Claim name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Claim
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Claim")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OAuth2Claim status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public OAuth2Claim system(Boolean system) {

        this.system = system;
        return this;
    }

    /**
     * When &#x60;true&#x60;, indicates that Okta created the Claim
     *
     * @return system
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "When `true`, indicates that Okta created the Claim")
    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }

    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSystem(Boolean system) {
        this.system = system;
    }

    public OAuth2Claim value(String value) {

        this.value = value;
        return this;
    }

    /**
     * Specifies the value of the Claim. This value must be a string literal if &#x60;valueType&#x60; is
     * &#x60;GROUPS&#x60;, and the string literal is matched with the selected &#x60;group_filter_type&#x60;. The value
     * must be an Okta EL expression if &#x60;valueType&#x60; is &#x60;EXPRESSION&#x60;.
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the value of the Claim. This value must be a string literal if `valueType` is `GROUPS`, and the string literal is matched with the selected `group_filter_type`. The value must be an Okta EL expression if `valueType` is `EXPRESSION`.")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public OAuth2Claim valueType(OAuth2ClaimValueType valueType) {

        this.valueType = valueType;
        return this;
    }

    /**
     * Get valueType
     *
     * @return valueType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VALUE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClaimValueType getValueType() {
        return valueType;
    }

    @JsonProperty(JSON_PROPERTY_VALUE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValueType(OAuth2ClaimValueType valueType) {
        this.valueType = valueType;
    }

    public OAuth2Claim links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2Claim oauth2Claim = (OAuth2Claim) o;
        return Objects.equals(this.alwaysIncludeInToken, oauth2Claim.alwaysIncludeInToken)
                && Objects.equals(this.claimType, oauth2Claim.claimType)
                && Objects.equals(this.conditions, oauth2Claim.conditions)
                && Objects.equals(this.groupFilterType, oauth2Claim.groupFilterType)
                && Objects.equals(this.id, oauth2Claim.id) && Objects.equals(this.name, oauth2Claim.name)
                && Objects.equals(this.status, oauth2Claim.status) && Objects.equals(this.system, oauth2Claim.system)
                && Objects.equals(this.value, oauth2Claim.value)
                && Objects.equals(this.valueType, oauth2Claim.valueType)
                && Objects.equals(this.links, oauth2Claim.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alwaysIncludeInToken, claimType, conditions, groupFilterType, id, name, status, system,
                value, valueType, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Claim {\n");
        sb.append("    alwaysIncludeInToken: ").append(toIndentedString(alwaysIncludeInToken)).append("\n");
        sb.append("    claimType: ").append(toIndentedString(claimType)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    groupFilterType: ").append(toIndentedString(groupFilterType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("    valueType: ").append(toIndentedString(valueType)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
