package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthClientSecretLinks;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2ClientJsonWebKey
 */
@JsonPropertyOrder({ OAuth2ClientJsonWebKey.JSON_PROPERTY_ALG, OAuth2ClientJsonWebKey.JSON_PROPERTY_CREATED,
        OAuth2ClientJsonWebKey.JSON_PROPERTY_E, OAuth2ClientJsonWebKey.JSON_PROPERTY_ID,
        OAuth2ClientJsonWebKey.JSON_PROPERTY_KID, OAuth2ClientJsonWebKey.JSON_PROPERTY_KTY,
        OAuth2ClientJsonWebKey.JSON_PROPERTY_LAST_UPDATED, OAuth2ClientJsonWebKey.JSON_PROPERTY_N,
        OAuth2ClientJsonWebKey.JSON_PROPERTY_STATUS, OAuth2ClientJsonWebKey.JSON_PROPERTY_USE,
        OAuth2ClientJsonWebKey.JSON_PROPERTY_LINKS })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T18:50:18.667445-05:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuth2ClientJsonWebKey implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;

    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    public static final String JSON_PROPERTY_E = "e";
    private String e;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_KID = "kid";
    private JsonNullable<String> kid = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;

    public static final String JSON_PROPERTY_N = "n";
    private String n;

    /**
     * Status of the OAuth 2.0 Client JSON Web Key
     */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),

        INACTIVE("INACTIVE"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;

    public static final String JSON_PROPERTY_USE = "use";
    private String use;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuthClientSecretLinks links;

    public OAuth2ClientJsonWebKey() {
    }

    /*
     * @JsonCreator public OAuth2ClientJsonWebKey(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) String created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) String lastUpdated ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; }
     */

    public OAuth2ClientJsonWebKey alg(String alg) {

        this.alg = alg;
        return this;
    }

    /**
     * Algorithm used in the key
     *
     * @return alg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "RS256", value = "Algorithm used in the key")
    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAlg() {
        return alg;
    }

    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    /**
     * Timestamp when the OAuth Client 2.0 JSON Web Key was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", value = "Timestamp when the OAuth Client 2.0 JSON Web Key was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreated() {
        return created;
    }

    public OAuth2ClientJsonWebKey e(String e) {

        this.e = e;
        return this;
    }

    /**
     * RSA key value (exponent) for key binding
     *
     * @return e
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "AQAB", value = "RSA key value (exponent) for key binding")
    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getE() {
        return e;
    }

    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    /**
     * The unique ID of the OAuth Client JSON Web Key
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "pks2f4zrZbs8nUa7p0g4", value = "The unique ID of the OAuth Client JSON Web Key")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public OAuth2ClientJsonWebKey kid(String kid) {
        this.kid = JsonNullable.<String> of(kid);

        return this;
    }

    /**
     * Unique identifier of the JSON Web Key in the OAUth 2.0 Client&#39;s JWKS
     *
     * @return kid
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value = "Unique identifier of the JSON Web Key in the OAUth 2.0 Client's JWKS")
    @JsonIgnore

    public String getKid() {
        return kid.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getKid_JsonNullable() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    public void setKid_JsonNullable(JsonNullable<String> kid) {
        this.kid = kid;
    }

    public void setKid(String kid) {
        this.kid = JsonNullable.<String> of(kid);
    }

    public OAuth2ClientJsonWebKey kty(String kty) {

        this.kty = kty;
        return this;
    }

    /**
     * Cryptographic algorithm family for the certificate&#39;s key pair
     *
     * @return kty
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "RSA", value = "Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getKty() {
        return kty;
    }

    @JsonProperty(JSON_PROPERTY_KTY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKty(String kty) {
        this.kty = kty;
    }

    /**
     * Timestamp when the OAuth Client 2.0 JSON Web Key was updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", value = "Timestamp when the OAuth Client 2.0 JSON Web Key was updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdated() {
        return lastUpdated;
    }

    public OAuth2ClientJsonWebKey n(String n) {

        this.n = n;
        return this;
    }

    /**
     * RSA key value (modulus) for key binding
     *
     * @return n
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "mkC6yAJVvFwUlmM9gKjb2d-YK5qHFt-mXSsbjWKKs4EfNm-BoQeeovBZtSACyaqLc8IYFTPEURFcbDQ9DkAL04uUIRD2gaHYY7uK0jsluEaXGq2RAIsmzAwNTzkiDw4q9pDL_q7n0f_SDt1TsMaMQayB6bU5jWsmqcWJ8MCRJ1aJMjZ16un5UVx51IIeCbe4QRDxEXGAvYNczsBoZxspDt28esSpq5W0dBFxcyGVudyl54Er3FzAguhgfMVjH-bUec9j2Tl40qDTktrYgYfxz9pfjm01Hl4WYP1YQxeETpSL7cQ5Ihz4jGDtHUEOcZ4GfJrPzrGpUrak8Qp5xcwCqQ", value = "RSA key value (modulus) for key binding")
    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getN() {
        return n;
    }

    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public OAuth2ClientJsonWebKey status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Status of the OAuth 2.0 Client JSON Web Key
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ACTIVE", value = "Status of the OAuth 2.0 Client JSON Web Key")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ClientJsonWebKey use(String use) {

        this.use = use;
        return this;
    }

    /**
     * Acceptable use of the JSON Web Key
     *
     * @return use
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "sig", value = "Acceptable use of the JSON Web Key")
    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUse() {
        return use;
    }

    @JsonProperty(JSON_PROPERTY_USE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUse(String use) {
        this.use = use;
    }

    public OAuth2ClientJsonWebKey links(OAuthClientSecretLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthClientSecretLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuthClientSecretLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientJsonWebKey oauth2ClientJsonWebKey = (OAuth2ClientJsonWebKey) o;
        return Objects.equals(this.alg, oauth2ClientJsonWebKey.alg)
                && Objects.equals(this.created, oauth2ClientJsonWebKey.created)
                && Objects.equals(this.e, oauth2ClientJsonWebKey.e)
                && Objects.equals(this.id, oauth2ClientJsonWebKey.id)
                && equalsNullable(this.kid, oauth2ClientJsonWebKey.kid)
                && Objects.equals(this.kty, oauth2ClientJsonWebKey.kty)
                && Objects.equals(this.lastUpdated, oauth2ClientJsonWebKey.lastUpdated)
                && Objects.equals(this.n, oauth2ClientJsonWebKey.n)
                && Objects.equals(this.status, oauth2ClientJsonWebKey.status)
                && Objects.equals(this.use, oauth2ClientJsonWebKey.use)
                && Objects.equals(this.links, oauth2ClientJsonWebKey.links);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(alg, created, e, id, hashCodeNullable(kid), kty, lastUpdated, n, status, use, links);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientJsonWebKey {\n");
        sb.append("    alg: ").append(toIndentedString(alg)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    e: ").append(toIndentedString(e)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    kty: ").append(toIndentedString(kty)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    n: ").append(toIndentedString(n)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    use: ").append(toIndentedString(use)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
